% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readLAS.r
\name{readlasdata}
\alias{readlasdata}
\title{Read data from a .las or .laz file}
\usage{
readlasdata(file, Intensity = TRUE, ReturnNumber = TRUE,
  NumberOfReturns = TRUE, ScanDirectionFlag = TRUE,
  EdgeOfFlightline = FALSE, Classification = TRUE, ScanAngle = TRUE,
  UserData = TRUE, PointSourceID = TRUE, RGB = TRUE)
}
\arguments{
\item{file}{characters path to the .las or .laz file}

\item{Intensity}{logical. do you want to load the Intensity field? default: TRUE}

\item{ReturnNumber}{logical. do you want to load the ReturnNumber field? default: TRUE}

\item{NumberOfReturns}{logical. do you want to load the NumberOfReturns field? default: TRUE}

\item{ScanDirectionFlag}{logical. do you want to load the ScanDirectionFlag field? default: TRUE}

\item{EdgeOfFlightline}{logical. do you want to load the EdgeOfFlightline field? default: TRUE}

\item{Classification}{logical. do you want to load the Classification field? default: TRUE}

\item{ScanAngle}{logical. do you want to load the ScanAngle field? default: TRUE}

\item{UserData}{logical. do you want to load the UserData field? default: TRUE}

\item{PointSourceID}{logical. do you want to load the PointSourceID field? default: FALSE}

\item{RGB}{logical. do you want to load R,G and B fields? default: TRUE}
}
\value{
A \code{data.table}
}
\description{
Read data from .las or .laz files in format 1 to 4 according to LAS specifications and returns
a \code{data.table} labeled according to LAS specifications. See the ASPRS documentation for the
\href{http://www.asprs.org/a/society/committees/standards/LAS_1_4_r13.pdf}{LAS file format}.
The optional logical parameters enable the user to save memory by choosing to load only the
fields they need. Indeed, the \code{readlasdata} function does not 'stream' the data.
Data is loaded into the computer's memory (RAM) suboptimally because R does not accommodate
many different data types.
}
\examples{
lazfile <- system.file("extdata", "example.laz", package="rlas")
lasdata <- readlasdata(lazfile)
}
\seealso{
Other rlas: \code{\link{readlasheader}},
  \code{\link{writelas}}
}

