% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readLAS.r
\name{readlasheader}
\alias{readlasheader}
\title{Read header from a .las or .laz file}
\usage{
readlasheader(file)
}
\arguments{
\item{file}{filepath character string to the .las or .laz file}
}
\value{
A \code{list}
}
\description{
Reads header from .las or .laz files in format 1 to 4 according to LAS specifications and returns
a \code{list} labeled according to LAS specifications. See the ASPRS documentation for the
\href{http://www.asprs.org/a/society/committees/standards/LAS_1_4_r13.pdf}{LAS file format}.
}
\examples{
lazfile   <- system.file("extdata", "example.laz", package="rlas")
lasheader <- readlasheader(lazfile)
}
\seealso{
Other rlas: \code{\link{readlasdata}},
  \code{\link{writelas}}
}
