% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lc.R
\name{lc_bars}
\alias{lc_bars}
\title{Create a barplot}
\usage{
lc_bars(data = list(), place = NULL, ..., id = NULL,
  layerId = NULL, addLayer = FALSE)
}
\arguments{
\item{data}{Name value pairs of properties, passed through the \code{\link{dat}} function. These
properties will be reevaluated on each \code{\link{updateCharts}} call.}

\item{place}{An ID of a container, where to place the chart. Will be ignored if the chart already
exists. If not defined, the chart will be placed directly in the body of the opened page.}

\item{...}{Name value pairs of properties that can be evaluated only once and then will remain
constant. These properties can still be changed later using the \code{\link{setProperties}} function}

\item{id}{An ID for the chart. All charts must have unique IDs. If a chart with the same ID already
exists, a new layer will be added to it. If you want to replace one chart with another, use \code{\link{removeChart}}
first. If not defined, the ID will be set to \code{ChartN}, where \code{N - 1} is the number of currently existing charts.}

\item{layerId}{An ID for the new layer. All layers within one chart must have different IDs. If a layer with the same
ID already exists, it will be replaced. If not defined, will be set to \code{LayerN}, where \code{N - 1}
is the number of currently existing layers in this chart.}

\item{addLayer}{whether to add a new layer or to replace the existing one. This argument influences the chart only if
it has only one layer and the \code{layerId} is not defined.}
}
\description{
\code{lc_bars} creates a new barplot and adds it on the page
as a new chart or as a new layer of an existing chart.
}
\section{Available properties}{

You can read more about different properties
\href{https://anders-biostat.github.io/linked-charts/rlc/tutorials/props.html}{here}.

\itemize{
\item \code{value} - heights of bars/stacks.
\item \code{stackIds} - IDs for all stacks (if necessary). Must be the same size as \code{values}.
\item \code{barIds} - IDs for all bars (if necessary). Must be the same size as \code{values}.
\item \code{groupIds} - IDs for all groups (if necessary). Must be the same size as \code{values}.
\item \code{groupWidth} - ratio of width of a group of bars to the space, available to the group. }

Style settings
\itemize{
\item \code{opacity} - opacity of each bar|stack in the range from 0 to 1.
\item \code{colour} - colour of each bar|stack. Must be a colour name or hexadecimal code.
\item \code{colourValue} - grouping values for different colours. Can be numbers or characters.
\item \code{colourDomain} - vector of all possible values for discrete colour scales
or range of all possible colour values for the continuous ones.
\item \code{palette} - vector of colours to construct the colour scale.
\item \code{colourLegendTitle} - title for the colour legend.
\item \code{addColourScaleToLegend} - whether or not to show colour legend for the current layer.
\item \code{globalColourScale} - whether or not to use one colour scale for all the layers.
\item \code{stroke} -  stroke colour of each bar|stack. Must be a colour name or hexadecimal code.
\item \code{strokeWidth} - width of the strokes of each bar|stack. }

Axes settings
\itemize{
\item \code{logScaleX, logScaleY} - a base of logarithm for logarithmic scale transformation.
If 0 or \code{FALSE} no transformation will be performed.
\item \code{layerDomainX, layerDomainY} - default axes ranges for the given layer.
\item \code{domainX, domainY} - default axes ranges for the entire chart. If not defined,
is automatically set to include all layer domains.
\item \code{contScaleX, consScaleY} - whether or not the axis should be continuous.
\item \code{aspectRatio} - aspect ratio.
\item \code{axisTitleX, axisTitleY} - axes titles.
\item \code{ticksRotateX, ticksRotateY} - degrees of angle to rotate ticks. Must be between
0 (horizontal ticks, default) and 90 (vertical ticks).
\item \code{ticksX, ticksY} - set of ticks for the axes.}

Interactivity settings
\itemize{
\item \code{on_click} - function, to be called, when one of the bars is clicked. Gets an
index of the clicked bar as an argument.
\item \code{on_mouseover} - function, to be called, when mouse hovers over one of the bars.
Gets an index of the clicked bar as an argument.
\item \code{on_mouseout} - function, to be called, when mouse moves out of one of the bars.
\item \code{on_marked} - function, to be called, when any of the bars are selected (marked)
or deselected. Use \code{\link{getMarked}} function to get the IDs of the currently marked bars.}

Global chart settings
\itemize{
\item \code{width} - width of the chart in pixels.
\item \code{heigth} - height of the chart in pixels.
\item \code{plotWidth} - width of the plotting area in pixels.
\item \code{plotHeight} - height of the plotting area in pixels.
\item \code{paddings} - paddings size in pixels. Must be a list with all the following fields:
\code{"top", "bottom", "left", "right"}.
\item \code{title} - title of the chart.
\item \code{titleX, titleY} - coordinates of the chart title.
\item \code{titleSize} - font-size of the chart title.
\item \code{showLegend} - whether or not to show the legend.
\item \code{showPanel} - whether of not to show the tools panel.
\item \code{transitionDuration} - duration of the transitions between any two states of the chart. If 0,
no animated transition is shown. It can be useful to turn the transition off, when lots of frequent
changes happen to the chart.}
}

\examples{
\donttest{data("esoph")

lc_bars(dat(value = tapply(esoph$ncases, esoph$agegp, sum), 
            title = "Number of cases per age group",
            axisTitleX = "Age group", 
            axisTitleY = "Number of esophageal cases"))

lc_bars(dat(value = c(tapply(esoph$ncases, esoph$agegp, sum), 
                      tapply(esoph$ncontrols, esoph$agegp, sum)),
            stackIds = c(rep("case", 6), rep("control", 6))))

#It is easy to put data in a convenient form for barplots using tidyverse
library(tidyverse)

esoph \%>\%
  gather(type, cases, (ncases:ncontrols)) \%>\%
  mutate(type = str_sub(type, 2, -2)) \%>\%
  group_by(agegp, alcgp, type) \%>\%
  summarise(ncases = sum(cases)) -> newData

lc_bars(dat(value = newData$ncases,
            stackIds = newData$type,
            barIds = newData$alcgp,
            groupIds = newData$agegp))}

}
