% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lc.R
\name{lc_input}
\alias{lc_input}
\title{Add input forms to the page}
\usage{
lc_input(data = list(), place = NULL, ..., id = NULL)
}
\arguments{
\item{data}{Name value pairs of properties, passed through the \code{\link{dat}} function. These
properties will be reevaluated on each \code{\link{updateCharts}} call.}

\item{place}{An ID of a container, where to place the chart. Will be ignored if the chart already
exists. If not defined, the chart will be placed directly in the body of the opened page.}

\item{...}{Name value pairs of properties that can be evaluated only once and then will remain
constant. These properties can still be changed later using the \code{\link{setProperties}} function}

\item{id}{An ID for the chart. All charts must have unique IDs. If a chart with the same ID already
exists, a new layer will be added to it. If you want to replace one chart with another, use \code{\link{removeChart}}
first. If not defined, the ID will be set to \code{ChartN}, where \code{N - 1} is the number of currently existing charts.}
}
\description{
\code{lc_input} adds an input form. This function is an rlc wrapper for an
HTML \code{<input>} tag. Five types of input are supported: \code{"text", "range", "checkbox", "radio" and "button"}.
}
\section{Available properties}{

You can read more about different properties
\href{https://anders-biostat.github.io/linked-charts/rlc/tutorials/props.html}{here}.

\itemize{
\item \code{type} - type of input. Must be one of \code{"text", "range", "checkbox", "radio", "button"}
\item \code{value} - current state of the input block. For radio buttons it is an idex of the checked
button. For checkboxes - a vector of \code{TRUE} (for each checked box) and \code{FALSE} (for each unchecked one),
for ranges and textfiels - a vector of values for each text field or slider.
\item \code{step} (only for \code{type = "range"}) - stepping interval for values that can be selected with a slider.
Must be a numeric vector with one value for each slider in the input block.
\item \code{min, max} (only for \code{type = "range"}) - minimal and maximal values that can be selected with a slider.
Must be a numeric vector with one value for each slider in the input block.
}

Interactivity settings
\itemize{
\item \code{on_click, on_change} - function, to be called, when user clicks on a button, enters text in a text field
or moves a slider. The two properties are complete synonymes and can replace one another.
}

Global chart settings
\itemize{
\item \code{title} - title of the input block.
\item \code{width} - width of the chart in pixels. By default, the entire content will be displayed.
If width is defined and it's smaller than content's width, scrolling will be possible.
\item \code{heigth} - height of the chart in pixels. By default, the entire content will be displayed.
If height is defined and it's smaller than content's height, scrolling will be possible.
\item \code{paddings} - paddings size in pixels. Must be a list with all the following fields:
\code{"top", "bottom", "left", "right"}.}
}

\examples{
\donttest{lc_input(type = "checkbox", labels = paste0("el", 1:5), on_click = function(value) print(value),
value = TRUE)
lc_input(type = "radio", labels = paste0("el", 1:5), on_click = function(value) print(value),
         value = 1)
lc_input(type = "text", labels = paste0("el", 1:5), on_click = function(value) print(value),
         value = c("a", "b", "c", "e", "d"))
lc_input(type = "range", labels = paste0("el", 1:5), on_click = function(value) print(value),
         value = 10, max = c(10, 20, 30, 40, 50), step = c(0.5, 0.1, 1, 5, 25))
lc_input(type = "button", labels = paste0("el", 1:5), on_click = function(value) print(value))}

}
