% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimumspanningtree.R
\name{MinSpanningTree}
\alias{MinSpanningTree}
\title{MinSpanningTree}
\usage{
MinSpanningTree(
  arcSources,
  arcTargets,
  arcDistances,
  numNodes,
  algorithm = "Kruskal"
)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's
edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's
edges}

\item{arcDistances}{Vector corresponding to the distances of nodes of a
graph's edges}

\item{numNodes}{The number of nodes in the graph}

\item{algorithm}{Which algorithm to run. Choices include "Kruskal" where
"Kruskal" is the default. See
<https://lemon.cs.elte.hu/pub/doc/1.3.1/a00610.html#ga233792b2c44a3581b85a775703e045af>
for more information.}
}
\value{
A list containing three entries: 1) Two vectors corresponding the
  source and target nodes of the edges in the tree, and 2) the total minimum
  spanning tree value.
}
\description{
Finds the minimum spanning tree of a graph.
The minimum spanning tree is the minimal connected acyclic subgraph of a graph,
assuming the graph is undirected.
}
