
test_that("Planarity Checking", {
  s <- c(1, 1, 1, 2, 2, 2, 3, 3, 3)
  t <- c(4, 5, 6, 4, 5, 6, 4, 5, 6)
  out <- PlanarCheckingRunner(s, t, 6)
  expect_is(out, "logical")
  expect_equal(out, FALSE)
  s <- c(1, 1, 1, 2, 2, 2, 3, 3, 3)
  t <- c(4, 5, 6, 4, 5, 6, 4, 5, 6)
  out <- PlanarChecking(s, t, 6)
  expect_is(out, "logical")
  expect_equal(out, FALSE)
})

test_that("Planar-Coloring Checking", {
  s <- c(1, 1, 1, 2, 2, 2, 3)
  t <- c(4, 5, 6, 4, 5, 6, 1)
  out <- PlanarColoringRunner(s, t, 6)
  expect_is(out[[1]], "logical")
  expect_equal(out[[1]], TRUE)
  expect_equal(out[[2]], c(1, 1, 0, 0, 0, 0))
  out <- PlanarColoringRunner(s, t, 6, FALSE)
  expect_is(out[[1]], "logical")
  expect_equal(out[[1]], TRUE)
  expect_equal(out[[2]], c(1, 1, 0, 0, 0, 0))
  out <- PlanarColoring(s, t, 6)
  expect_is(out[[1]], "logical")
  expect_equal(out[[1]], TRUE)
  expect_equal(out[[2]], c(1, 1, 0, 0, 0, 0))
  out <- PlanarColoring(s, t, 6, "sixColoring")
  expect_is(out[[1]], "logical")
  expect_equal(out[[1]], TRUE)
  expect_equal(out[[2]], c(1, 1, 0, 0, 0, 0))
  expect_error(PlanarColoring(s, t, 6, "blahblah"))

})


test_that("Planar-Drawing Checking", {
  s <- c(1, 1, 1, 2, 2, 2, 3)
  t <- c(4, 5, 6, 4, 5, 6, 1)
  out <- PlanarDrawingRunner(s, t, 6)
  expect_is(out[[1]], "logical")
  expect_equal(out[[1]], TRUE)
  expect_equal(out[[2]], c(2, 1, 1, 4, 2, 0))
  expect_equal(out[[3]], c(2, 0, 2, 1, 1, 4))
  out <- PlanarDrawing(s, t, 6)
  expect_is(out[[1]], "logical")
  expect_equal(out[[1]], TRUE)
  expect_equal(out[[2]], c(2, 1, 1, 4, 2, 0))
  expect_equal(out[[3]], c(2, 0, 2, 1, 1, 4))
})

test_that("Planar-Embedding Checking", {
  s <- c(1, 1, 1, 2, 2, 2, 3, 3, 3)
  t <- c(4, 5, 6, 4, 5, 6, 4, 5, 6)
  n <- 6
  out <- PlanarEmbeddingRunner(s, t, n)
  expect_equal(out[[1]], 0)
  expect_equal(out[[2]], integer())
  expect_equal(out[[3]], integer())
  expect_equal(out[[4]], c(1, 1, 1, 2, 2, 2, 3, 3, 3))
  expect_equal(out[[5]], c(4, 5, 6, 4, 5, 6, 4, 5, 6))
  out <- PlanarEmbedding(s, t, n)
  expect_equal(out[[1]], 0)
  expect_equal(out[[2]], integer())
  expect_equal(out[[3]], integer())
  expect_equal(out[[4]], c(1, 1, 1, 2, 2, 2, 3, 3, 3))
  expect_equal(out[[5]], c(4, 5, 6, 4, 5, 6, 4, 5, 6))

  s <- c(1, 1, 1, 2, 2, 2, 3)
  t <- c(4, 5, 6, 4, 5, 6, 1)
  n <- 6
  out <- PlanarEmbeddingRunner(s, t, n)
  expect_equal(out[[1]], 1)
  expect_equal(out[[2]], c(1, 1, 1, 1, 2, 2, 2, 3, 4, 4, 5, 5, 6, 6))
  expect_equal(out[[3]], c(3, 5, 4, 6, 6, 4, 5, 1, 2, 1, 2, 1, 2, 1))
  expect_equal(out[[4]], integer())
  expect_equal(out[[5]], integer())
  out <- PlanarEmbedding(s, t, n)
  expect_equal(out[[1]], 1)
  expect_equal(out[[2]], c(1, 1, 1, 1, 2, 2, 2, 3, 4, 4, 5, 5, 6, 6))
  expect_equal(out[[3]], c(3, 5, 4, 6, 6, 4, 5, 1, 2, 1, 2, 1, 2, 1))
  expect_equal(out[[4]], integer())
  expect_equal(out[[5]], integer())
})
