% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connectivity.R
\name{FindStronglyConnectedCutArcs}
\alias{FindStronglyConnectedCutArcs}
\title{Find Strongly Connected Cut Arcs}
\usage{
FindStronglyConnectedCutArcs(arcSources, arcTargets, numNodes)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's
edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's
edges}

\item{numNodes}{The number of nodes in the graph}
}
\value{
A list containing 1) A vector of cut arc sources, and 2) A vector of
  cut arc destinations.
}
\description{
The strongly connected components are the classes of an equivalence relation
on the nodes of a directed graph. Two nodes are in the same class if they
are connected with directed paths in both direction. The strongly connected
components are separated by the cut arcs.
}
\details{
See
\url{https://lemon.cs.elte.hu/pub/doc/1.3.1/a00616.html#gad7af5c3a97453e37f251f0e86dbb83db}
for more information.
}
