% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NoiseKrigingClass.R
\name{as.km.NoiseKriging}
\alias{as.km.NoiseKriging}
\title{Coerce a \code{NoiseKriging} Object into the Class \code{"km"}}
\usage{
\method{as.km}{NoiseKriging}(x, .call = NULL, ...)
}
\arguments{
\item{x}{An object with S3 class \code{"NoiseKriging"}.}

\item{.call}{Force the \code{call} slot to be filled in the
returned \code{km} object.}

\item{...}{Not used.}
}
\value{
An object of having the S4 class \code{"KM"} which extends
    the \code{"km"} class of the \pkg{DiceKriging} package and
    contains an extra \code{NoiseKriging} slot.
}
\description{
Coerce a \code{NoiseKriging} object into the \code{"km"} class of the
\pkg{DiceKriging} package.
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X) + X/10 * rnorm(nrow(X)) # add noise dep. on X
## fit and print
k <- NoiseKriging(y, noise=(X/10)^2, X, kernel = "matern3_2")
print(k)

k_km <- as.km(k)
print(k_km)
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
