% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NoiseKrigingClass.R
\name{fit.NoiseKriging}
\alias{fit.NoiseKriging}
\title{Fit \code{NoiseKriging} object on given data.}
\usage{
\method{fit}{NoiseKriging}(
  object,
  y,
  noise,
  X,
  regmodel = c("constant", "linear", "interactive", "none"),
  normalize = FALSE,
  optim = c("BFGS", "none"),
  objective = c("LL"),
  parameters = NULL,
  ...
)
}
\arguments{
\item{object}{S3 NoiseKriging object.}

\item{y}{Numeric vector of response values.}

\item{noise}{Numeric vector of response variances.}

\item{X}{Numeric matrix of input design.}

\item{regmodel}{Universal NoiseKriging 
\code{"linear"}, \code{"interactive"}, \code{"quadratic"}.}

\item{normalize}{Logical. If \code{TRUE} both the input matrix
\code{X} and the response \code{y} in normalized to take
values in the interval \eqn{[0, 1]}.}

\item{optim}{Character giving the Optimization method used to fit
hyper-parameters. Possible values are: \code{"BFGS"} and \code{"none"},
the later simply keeping
the values given in \code{parameters}. The method
\code{"BFGS"} uses the gradient of the objective 
(note that \code{"BGFS10"} means 10 multi-start of BFGS).}

\item{objective}{Character giving the objective function to
optimize. Possible values are: \code{"LL"} for the
Log-Likelihood.}

\item{parameters}{Initial values for the hyper-parameters. When
provided this must be named list with elements \code{"sigma2"}
and \code{"theta"} containing the initial value(s) for the
variance and for the range parameters. If \code{theta} is a
matrix with more than one row, each row is used as a starting
point for optimization.}

\item{...}{Ignored.}
}
\value{
No return value. NoiseKriging object argument is modified.
}
\description{
The hyper-parameters (variance and vector of correlation ranges)
are estimated thanks to the optimization of a criterion given by
\code{objective}, using the method given in \code{optim}.
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
plot(f)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X) + X/10 * rnorm(nrow(X)) # add noise dep. on X
points(X, y, col = "blue", pch = 16)

k <- NoiseKriging("matern3_2")
print(k)

fit(k,y,noise=(X/10)^2,X)
print(k)
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
