% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{linkGenesAndPeaks}
\alias{linkGenesAndPeaks}
\title{Linking genes to putative regulatory elements}
\usage{
linkGenesAndPeaks(
  gene_counts,
  peak_counts,
  genes.list = NULL,
  dist = "spearman",
  alpha = 0.05,
  path_to_coords,
  verbose = TRUE
)
}
\arguments{
\item{gene_counts}{A gene expression matrix (genes by cells) of normalized counts.
This matrix has to share the same column names (cell barcodes) as the matrix passed to peak_counts}

\item{peak_counts}{A peak-level matrix (peaks by cells) of normalized accessibility values, such as the one resulting from imputeKNN.
This matrix must share the same column names (cell barcodes) as the matrix passed to gene_counts.}

\item{genes.list}{A list of the genes symbols to be tested. If not specified,
this function will use all the gene symbols from the matrix passed to gmat by default.}

\item{dist}{This indicates the type of correlation to calculate -- one of “spearman” (default), "pearson", or "kendall".}

\item{alpha}{Significance threshold for correlation p-value. Peak-gene correlations with p-values below
this threshold are considered significant. The default is 0.05.}

\item{path_to_coords}{Path to the gene coordinates file.}

\item{verbose}{Print messages (TRUE by default)}
}
\value{
a sparse matrix with peak names as rows and gene symbols as columns, with each element indicating the
correlation between peak i and gene j (or 0 if the gene and peak are not significantly linked).
}
\description{
Evaluate the relationships between pairs of genes and peaks based on specified distance metric.
}
\examples{
\dontrun{
# some gene counts matrix: gmat.small
# some peak counts matrix: pmat.small 
regnet <- linkGenesAndPeaks(gmat.small, pmat.small, dist = "spearman",
alpha = 0.05, path_to_coords = 'some_path')
}
}
