% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotGeneLoadings}
\alias{plotGeneLoadings}
\alias{plotGeneLoadingRank}
\title{Visualize factor expression and gene loading}
\usage{
plotGeneLoadings(
  object,
  markerTable,
  useFactor,
  useDimRed = NULL,
  nLabel = 15,
  nPlot = 30,
  ...
)

plotGeneLoadingRank(
  object,
  markerTable,
  useFactor,
  nLabel = 15,
  nPlot = 30,
  ...
)
}
\arguments{
\item{object}{A \linkS4class{liger} object with valid factorization result.}

\item{markerTable}{Returned result of \code{\link{getFactorMarkers}}.}

\item{useFactor}{Integer index for which factor to visualize.}

\item{useDimRed}{Name of the variable storing dimensionality reduction result
in the \code{cellMeta} slot. Default \code{"UMAP"}.}

\item{nLabel}{Integer, number of top genes to be shown with text labels.
Default \code{15}.}

\item{nPlot}{Integer, number of top genes to be shown in the loading rank
plot. Default \code{30}.}

\item{...}{Additional plot theme setting arguments passed to
\code{\link{.ggScatter}} and \code{\link{.ggplotLigerTheme}}.}
}
\description{
Visualize factor expression and gene loading
}
\examples{
result <- getFactorMarkers(pbmcPlot, "ctrl", "stim")
plotGeneLoadings(pbmcPlot, result, useFactor = 2)
}
