#' rmapzen: A client application for the 'Mapzen' API.
#'
#' The rmapzen package provides interfaces to the Search
#' (\url{https://mapzen.com/documentation/search/}), Isochrone
#' (\url{https://mapzen.com/documentation/mobility/isochrone/api-reference/}),
#' and Vector Tile (\url{https://mapzen.com/documentation/vector-tiles/})
#' services from 'Mapzen', via the following functions:
#'
#' @section Search:
#' All functionality described in \url{https://mapzen.com/documentation/search/}
#' are supported:
#'
#' \itemize{
#'     \item \code{\link{mz_search}}
#'     \item \code{\link{mz_reverse_geocode}}
#'     \item \code{\link{mz_autocomplete}}
#'     \item \code{\link{mz_place}}
#'     \item \code{\link{mz_structured_search}}
#' }
#'
#' Additionally, \code{\link{mz_geocode}} is useful for a common application of
#' search, that of just obtaining latitude and longitude for a given address or place.
#'
#' @section Isochrone:
#' Isochrones are the areas reachable from a given location within a specified
#' period of time. Mapzen's Isochrone service can calculate isochrones for driving,
#' walking, cycling, or multimodal forms of transport:
#'
#' \itemize{
#'     \item \code{\link{mz_isochrone}}
#'     \item \code{\link{mz_costing}}: for constructing "costing models" that describe
#'     method of transport along with speed and other options relevant to the
#'     calculation of the isochrone
#'     \item \code{\link{mz_costing_options}}: for selecting specific options when
#'     constructing a costing model
#' }
#'
#' @section Vector Tiles:
#' \itemize{
#'     \item \code{\link{mz_vector_tiles}}: Request one or more adjacent tiles.
#'     Multiple map tiles will be stitched together before being returned as a single
#'     object.
#'     \item \code{\link{mz_tile_coordinates}}: When using \code{\link{mz_vector_tiles}},
#'     you must specify the geographic area for which you want tile data. One way to do so
#'     is using the x, y, z tile naming system (see \url{https://wiki.openstreetmap.org/wiki/Slippy_map_tilenames}).
#'     \item \code{\link{mz_rect}}: Alternatively, you can specify the lower left
#'     and top-right points of a bounding box, which will automatically be converted
#'     to tile-coordinates when you use \code{\link{mz_vector_tiles}}
#'     \item \code{\link{mz_bbox}}: This is a generic function which will return
#'     the bounding box of any Mapzen object. In this way, you can request vector
#'     tiles for a region defined as the bounding box of an existing object.
#' }
#'
#' @section Data types and conversion:
#' Objects returned by rmapzen can be converted to both Spatial*DataFrames and
#' simple features (sf) via the generic functions \code{\link{as_sp}}
#' (for Spatial*DataFrames) and \code{\link{as_sf}} (for simple features). Search
#' and Isochrone objects can additionally be converted to ordinary data.frames
#' via \code{as.data.frame}.
#'
#' @seealso
#' \itemize{
#'     \item \url{https://tarakc02.github.io/rmapzen/} contains detailed examples
#'     \item \url{https://mapzen.com/documentation/} 'Mapzen' documentation
#' }
#'
#' @docType package
#' @name rmapzen
NULL
