% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/output_format.R
\name{default_output_format}
\alias{default_output_format}
\title{Determine the default output format for an R Markdown document}
\usage{
default_output_format(input, encoding = getOption("encoding"))
}
\arguments{
\item{input}{Input file (Rmd or plain markdown)}

\item{encoding}{The encoding of the input file; see \code{\link{file}}}
}
\value{
A named list with a \code{name} value containing the format
  name and an \code{options} value that is a list containing all the options
  for the format and their values. An option's default value will be returned
  if the option isn't set explicitly in the document.
}
\description{
Read the YAML metadata (and any common _output.yaml file) for the
document and return the output format that will be generated by
a call to \code{\link{render}}.
}
\details{
This function is useful for front-end tools that require additional
knowledge of the output to be produced by \code{\link{render}} (e.g. to
customize the preview experience).
}

