% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf_document.R
\name{rtf_document}
\alias{rtf_document}
\title{Convert to an RTF document}
\usage{
rtf_document(toc = FALSE, toc_depth = 3, fig_width = 5, fig_height = 4,
  keep_md = FALSE, md_extensions = NULL, pandoc_args = NULL)
}
\arguments{
\item{toc}{\code{TRUE} to include a table of contents in the output}

\item{toc_depth}{Depth of headers to include in table of contents}

\item{fig_width}{Default width (in inches) for figures}

\item{fig_height}{Default width (in inches) for figures}

\item{keep_md}{Keep the markdown file generated by knitting.}

\item{md_extensions}{Markdown extensions to be added or removed from the
default definition or R Markdown. See the \code{\link{rmarkdown_format}} for
additional details.}

\item{pandoc_args}{Additional command line options to pass to pandoc}
}
\value{
R Markdown output format to pass to \code{\link{render}}
}
\description{
Format for converting from R Markdown to an RTF document.
}
\details{
See the \href{http://rmarkdown.rstudio.com/rtf_document_format.html}{online
documentation} for additional details on using the \code{rtf_document} format.

R Markdown documents can have optional metadata that is used to generate a
document header that includes the title, author, and date. For more details
see the documentation on R Markdown \link[=rmd_metadata]{metadata}.

R Markdown documents also support citations. You can find more information on
the markdown syntax for citations in the
\href{http://rmarkdown.rstudio.com/authoring_bibliographies_and_citations.html}{Bibliographies
and Citations} article in the online documentation.
}
\examples{
\dontrun{

library(rmarkdown)

# simple invocation
render("input.Rmd", rtf_document())

# specify table of contents option
render("input.Rmd", rtf_document(toc = TRUE))
}

}
