% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Rmumps__ptr_ijv}
\alias{Rmumps__ptr_ijv}
\title{Construct via Triplet Pointers}
\usage{
Rmumps__ptr_ijv(pi, pj, pa, n, nz, sym)
}
\arguments{
\item{pi}{pointer of type XPtr<int>, vector of i-indeces for sparse triplet}

\item{pj}{pointer of type XPtr<int>, vector of j-indeces for sparse triplet}

\item{pa}{pointer of type XPtr<double>, vector or values for sparse triplet}

\item{n}{integer, size of the matrix (n x n)}

\item{nz}{integer, number of non zeros in the matrix}

\item{sym}{integer, 0 means general (non symmetric) matrix, 1 - symmetric with pivotes on the main diagonal, 2 - general symmetric (pivotes may be anywhere)}
}
\value{
pointer of type XPtr<Rmumps> pointing to newly created object. To avoid memory leakage, it is user's responsibility to call \code{Rmumps__del_ptr(pm)} in a due moment (where \code{pm} is the returned pointer).
}
\description{
This is a C wrapper to \code{Rmumps::Rmumps(i, j, v, n, nz, sym)} constructor. Available in R too.
In C++ code can be used as \code{rmumps::Rmumps__ptr_ijv(pi, pj, pa, n, nz, sym)}
}
