% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{nassqs_record_count}
\alias{nassqs_record_count}
\title{Get a count of number of records for given parameters.}
\usage{
nassqs_record_count(params, ...)
}
\arguments{
\item{params}{a named list of parameters and values.}

\item{...}{additional parameters passed to \code{\link{nassqs_GET}}.}
}
\value{
integer that is the number of records that fits those parameter values.
}
\description{
Returns the number of records that fit a set of parameters. Useful if your
current parameter set returns more than the 50,000 record limit.
}
\examples{
\donttest{
  #Check the number of records returned for corn in 1995, Washington state
  params = list(
    commodity_desc = "CORN",
    year = "2005",
    agg_level_desc = "STATE",
    state_name = "WASHINGTON"
  )
  
  nassqs_record_count(params) #returns 17.

}
}
