% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainr.R
\name{trainr}
\alias{trainr}
\title{Recurrent Neural Network}
\usage{
trainr(Y, X, learningrate, learningrate_decay = 1, momentum = 0, hidden_dim,
  numepochs = 1, start_from_end = FALSE)
}
\arguments{
\item{Y}{array of output values, dim 1: samples (must be equal to dim 1 of X), dim 2: time (must be equal to dim 2 of X), dim 3: variables (could be 1 or more, if a matrix, will be coerce to array)}

\item{X}{array of input values, dim 1: samples, dim 2: time, dim 3: variables (could be 1 or more, if a matrix, will be coerce to array)}

\item{learningrate}{learning rate to be applied for weight iteration}

\item{learningrate_decay}{coefficient to apply to the learning rate at each weight iteration}

\item{momentum}{coefficient of the last weight iteration to keep for faster learning}

\item{hidden_dim}{dimension of hidden layer}

\item{numepochs}{number of iteration, i.e. number of time the whole dataset is presented to the network}

\item{start_from_end}{should the sequence start from the end}
}
\value{
a model to be used by the predictr function
}
\description{
Trains a Recurrent Neural Network.
}
\examples{
# create training numbers
X1 = sample(0:127, 7000, replace=TRUE)
X2 = sample(0:127, 7000, replace=TRUE)

# create training response numbers
Y <- X1 + X2

# convert to binary
X1 <- int2bin(X1, length=8)
X2 <- int2bin(X2, length=8)
Y  <- int2bin(Y,  length=8)

# create 3d array: dim 1: samples; dim 2: time; dim 3: variables
X <- array( c(X1,X2), dim=c(dim(X1),2) )

# train the model
model <- trainr(Y=Y,
                X=X,
                learningrate   =  0.1,
                hidden_dim     = 10,
                start_from_end = TRUE )
    
}

