% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdc_plot.r
\name{ncdc_plot}
\alias{ncdc_plot}
\title{Plot NOAA climate data.}
\usage{
ncdc_plot(..., breaks = NULL, dateformat = "\%d/\%m/\%y")
}
\arguments{
\item{...}{Input noaa object or objects.}

\item{breaks}{Regularly spaced date breaks for x-axis. See examples for
usage. See \link{date_breaks}. Default: \code{NULL} (uses ggplot2 default break
sformatting)}

\item{dateformat}{Date format using standard POSIX specification for labels
on x-axis. See \code{\link[=date_format]{date_format()}}}
}
\value{
ggplot2 plot
}
\description{
Plot NOAA climate data.
}
\details{
This function accepts directly output from the \code{\link[=ncdc]{ncdc()}} function,
not other functions.

This is a simple wrapper function around some ggplot2 code. There is indeed
a lot you can modify in your plots, so this function just does some basic
stuff. Look at the internals for what the function does.
}
\examples{
\dontrun{
# Search for data first, then plot
out <- ncdc(datasetid='GHCND', stationid='GHCND:USW00014895', datatypeid='PRCP',
   startdate = '2010-05-01', enddate = '2010-10-31', limit=500)
ncdc_plot(out)
ncdc_plot(out, breaks="14 days")
ncdc_plot(out, breaks="1 month", dateformat="\%d/\%m")
ncdc_plot(out, breaks="1 month", dateformat="\%d/\%m")

# Combine many calls to ncdc function
out1 <- ncdc(datasetid='GHCND', stationid='GHCND:USW00014895', datatypeid='PRCP',
   startdate = '2010-03-01', enddate = '2010-05-31', limit=500)
out2 <- ncdc(datasetid='GHCND', stationid='GHCND:USW00014895', datatypeid='PRCP',
   startdate = '2010-09-01', enddate = '2010-10-31', limit=500)
df <- ncdc_combine(out1, out2)
ncdc_plot(df)
## or pass in each element separately
ncdc_plot(out1, out2, breaks="45 days")
}
}
\seealso{
Other ncdc: 
\code{\link{ncdc_combine}()},
\code{\link{ncdc_datacats}()},
\code{\link{ncdc_datasets}()},
\code{\link{ncdc_datatypes}()},
\code{\link{ncdc_locs_cats}()},
\code{\link{ncdc_locs}()},
\code{\link{ncdc_stations}()},
\code{\link{ncdc}()}
}
\concept{ncdc}
