% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seaice.r
\name{sea_ice}
\alias{sea_ice}
\title{Get sea ice data.}
\usage{
sea_ice(year = NULL, month = NULL, pole = NULL, format = "shp", ...)
}
\arguments{
\item{year}{(numeric) a year}

\item{month}{(character) a month, as character abbrevation of a month}

\item{pole}{(character) one of S (south) or N (north)}

\item{format}{(character) one of shp (default), geotiff-extent (for geotiff
extent data), or geotiff-conc (for geotiff concentration data)}

\item{...}{Further arguments passed on to \code{rgdal::readshpfile()} if
\code{format="shp"} or \code{raster::raster()} if not}
}
\value{
data.frame if \code{format="shp"} (a fortified sp object);
\code{raster::raster()} if not
}
\description{
Get sea ice data.
}
\examples{
\dontrun{
if (requireNamespace("raster")) {

## one year, one moth, one pole
sea_ice(year = 1990, month = "Apr", pole = "N")
sea_ice(year = 1990, month = "Apr", pole = "N", format = "geotiff-extent")
sea_ice(year = 1990, month = "Apr", pole = "N", format = "geotiff-conc")

## one year, one month, many poles
sea_ice(year = 1990, month = "Apr")

## one year, many months, many poles
sea_ice(year = 1990, month = c("Apr", "Jun", "Oct"))

## many years, one month, one pole
sea_ice(year = 1990:1992, month = "Sep", pole = "N")

# get geotiff instead of shp data. 
x <- sea_ice(year = 1990, month = "Apr", format = "geotiff-extent")
y <- sea_ice(year = 1990, month = "Apr", format = "geotiff-conc")
}

}
}
\references{
See the "User Guide" pdf at https://nsidc.org/data/g02135
}
\seealso{
\code{\link[=sea_ice_tabular]{sea_ice_tabular()}}
}
