% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density_plot.R
\name{density_plot}
\alias{density_plot}
\alias{density_plot.default}
\alias{density_plot.sobel_test_mediation}
\alias{density_plot.list}
\alias{density_plot.setup_density_plot}
\title{Density plot of the indirect effect(s)}
\usage{
density_plot(object, ...)

\method{density_plot}{default}(object, ...)

\method{density_plot}{sobel_test_mediation}(object, grid = NULL, level = 0.95, ...)

\method{density_plot}{list}(object, grid = NULL, level = 0.95, ...)

\method{density_plot}{setup_density_plot}(object, ...)
}
\arguments{
\item{object}{an object inheriting from class
\code{"\link{test_mediation}"} containing results from
(robust) mediation analysis, or a list of such objects.}

\item{\dots}{additional arguments to be passed down.}

\item{grid}{an optional numeric vector containing the values at which to
evaluate the assumed normal density from Sobel's test.  The default is to
take 512 equally spaced points between the estimated indirect effect
\eqn{\pm}{+/-} three times the standard error according to Sobel's formula.}

\item{level}{numeric;  the confidence level of the confidence intervals
from Sobel's test.  The default is to include 95\% confidence intervals.
Note that this is not used for bootstrap tests, as those require to specify
the confidence level already in \code{\link{test_mediation}()}.}
}
\value{
An object of class \code{"\link[ggplot2]{ggplot}"}.
}
\description{
Produce a density plot of the indirect effect(s) from (robust) mediation
analysis.  In addition to the density, a vertical line representing the
point estimate and a shaded area representing the confidence interval are
drawn.
}
\details{
Methods first call \code{\link{setup_density_plot}()} to extract all
necessary information to produce the plot, then the
\code{"setup_density_plot"} method is called to produce the plot.
}
\examples{
data("BSG2014")

# run fast-and-robust bootstrap test
robust_boot <- test_mediation(BSG2014,
                              x = "ValueDiversity",
                              y = "TeamCommitment",
                              m = "TaskConflict",
                              robust = TRUE)

# create plot for robust bootstrap test
density_plot(robust_boot)
density_plot(robust_boot, color = "#00BFC4", fill = "#00BFC4")

# run OLS bootstrap test
ols_boot <- test_mediation(BSG2014,
                           x = "ValueDiversity",
                           y = "TeamCommitment",
                           m = "TaskConflict",
                           robust = FALSE)

# compare robust and OLS bootstrap tests
boot_list <- list("OLS bootstrap" = ols_boot,
                  "ROBMED" = robust_boot)
density_plot(boot_list)

# the plot can be customized in the usual way
density_plot(boot_list) + theme_bw() +
  labs(title = "OLS bootstrap vs ROBMED")

}
\references{
Alfons, A., Ates, N.Y. and Groenen, P.J.F. (2022) Robust Mediation Analysis:
The \R Package \pkg{robmed}.  \emph{Journal of Statistical Software},
\bold{103}(13), 1--45.  doi:10.18637/jss.v103.i13.
}
\seealso{
\code{\link{test_mediation}()}, \code{\link{setup_density_plot}()}

\code{\link{ci_plot}()}, \code{\link{ellipse_plot}()},
\code{\link{weight_plot}()}, \code{\link[=plot-methods]{plot}()}
}
\author{
Andreas Alfons
}
\keyword{hplot}
