% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_recoding.R
\name{generic_recoding}
\alias{generic_recoding}
\title{Generic underlying recoding function}
\usage{
generic_recoding(
  input,
  codes,
  func,
  filter = TRUE,
  output = NULL,
  outputPrefix = "",
  outputSuffix = "_recoded",
  decisionLabel = NULL,
  justification = NULL,
  justificationFile = NULL,
  preventOverwriting = rock::opts$get("preventOverwriting"),
  encoding = rock::opts$get("encoding"),
  silent = rock::opts$get("silent"),
  ...
)
}
\arguments{
\item{input}{One of 1) a character string specifying the path to a file
with a source; 2) an object with a loaded source as produced by a call
to \code{\link[=load_source]{load_source()}}; 3) a character string specifying the path to a
directory containing one or more sources; 4) or an object with a list of
loaded sources as produced by a call to \code{\link[=load_sources]{load_sources()}}.}

\item{codes}{The codes to process}

\item{func}{The function to apply.}

\item{filter}{Optionally, a filter to apply to specify a subset of the
source(s) to process (see \code{\link[=get_source_filter]{get_source_filter()}}).}

\item{output}{If specified, the coded source will be written here.}

\item{outputPrefix, outputSuffix}{The prefix and suffix to add to the
filenames when writing the processed files to disk, in case multiple
sources are passed as input.}

\item{decisionLabel}{A description of the (recoding) decision that was taken.}

\item{justification}{The justification for this action.}

\item{justificationFile}{If specified, the justification is appended to
this file. If not, it is saved to the \code{justifier::workspace()}. This can
then be saved or displayed at the end of the R Markdown file or R script
using \code{justifier::save_workspace()}.}

\item{preventOverwriting}{Whether to prevent overwriting existing files
when writing the files to \code{output}.}

\item{encoding}{The encoding to use.}

\item{silent}{Whether to be chatty or quiet.}

\item{...}{Other arguments to pass to \code{fnc}.}
}
\value{
Invisibly, the recoded source(s) or source(s) object.
}
\description{
This function contains the general set of actions that are always used
when recoding a source (e.g. check the input, document the
justification, etc). Users should normally never call this function.
}
