% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsed_sources_to_ena_network.R
\name{parsed_sources_to_ena_network}
\alias{parsed_sources_to_ena_network}
\title{Create an ENA network out of one or more parsed sources}
\usage{
parsed_sources_to_ena_network(
  x,
  unitCols,
  conversationCols = "originalSource",
  codes = x$convenience$codingLeaves,
  metadata = x$convenience$attributesVars
)
}
\arguments{
\item{x}{The parsed source(s) as provided by \code{rock::parse_source} or \code{rock::parse_sources}.}

\item{unitCols}{The columns that together define units (e.g. utterances in each
source that belong together, for example because they're about the same topic).}

\item{conversationCols}{The columns that together define conversations (e.g. separate
sources, but can be something else, as well).}

\item{codes}{The codes to include; by default, takes all codes.}

\item{metadata}{The columns in the merged source dataframe that contain the
metadata. By default, takes all read metadata.}
}
\value{
The result of a call to \code{rENA::ena.plot.network()}, if that is
installed.
}
\description{
Create an ENA network out of one or more parsed sources
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Parse a selection of example sources in that directory
parsedExamples <-
  rock::parse_sources(
    examplePath,
    regex = "(test|example)(.txt|.rock)"
  );

### Add something to indicate which units belong together; normally,
### these would probably be indicated using one of the identifier,
### for example the stanza identifiers, the sid's
nChunks <- nrow(parsedExamples$mergedSourceDf) \%/\% 10;
parsedExamples$mergedSourceDf$units <-
  c(rep(1:nChunks, each=10), rep(max(nChunks), nrow(parsedExamples$mergedSourceDf) - (10*nChunks)));

### Generate ENA plot
\donttest{
enaPlot <-
  rock::parsed_sources_to_ena_network(parsedExamples,
                                      unitCols='units');

### Show the resulting plot
print(enaPlot);
}

}
