% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rocker-R6-class.R
\name{rocker-R6-class}
\alias{rocker-R6-class}
\alias{rocker}
\title{'rocker' Database Interface R6 Class}
\format{
\link[R6:R6Class]{R6Class}
}
\description{
\link{R6} class interface for handling database connections using \link{DBI} package as backend. The class allows handling of connections to e.g. PostgreSQL, MariaDB and SQLite.
}
\examples{
# New database handling object
db <- rocker::newDB()
# Setup SQLite database
db$setupSQLite()
# Open connection
db$connect()
# Write table
db$writeTable("mtcars", mtcars)
# Get query
output <- db$getQuery("SELECT * FROM mtcars;")
# Close connection
db$disconnect()
# Reset database handling object
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$setupDriver`
## ------------------------------------------------

db <- rocker::newDB()
db$setupDriver(
  drv = RSQLite::SQLite(),
  dbname = ":memory:"
)
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$setupPostgreSQL`
## ------------------------------------------------

db <- rocker::newDB()
db$setupPostgreSQL(
  host = "127.0.0.1", port = "5432", dbname = "mydb",
  user = "postgres", password = "password"
)
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$setupMariaDB`
## ------------------------------------------------

db <- rocker::newDB()
db$setupMariaDB(
  host = "127.0.0.1", port = "3306", dbname = "mydb",
  user = "root", password = "password"
)
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$setupSQLite`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite(
  dbname = ":memory:"
)
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$unloadDriver`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$canConnect`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$canConnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$connect`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$disconnect`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$sendQuery`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
output <- db$fetch()
db$clearResult()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$getQuery`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
output <- db$getQuery("SELECT * FROM mtcars;")
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$sendStatement`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendStatement("DELETE FROM mtcars WHERE gear = 3;")
db$clearResult()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$execute`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$execute("DELETE FROM mtcars WHERE gear = 3;")
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$fetch`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
output <- db$fetch()
db$clearResult()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$hasCompleted`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
output <- db$fetch(5)
db$hasCompleted()
db$clearResult()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$getRowsAffected`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendStatement("DELETE FROM mtcars WHERE gear = 3;")
db$getRowsAffected()
db$clearResult()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$getRowCount`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
output <- db$fetch()
db$getRowCount()
db$clearResult()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$columnInfo`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
db$columnInfo()
db$clearResult()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$getStatement`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
db$getStatement()
db$clearResult()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$clearResult`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
output <- db$fetch()
db$clearResult()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$begin`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$begin()
db$sendStatement("DELETE FROM mtcars WHERE gear = 3;")
db$clearResult()
db$commit()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$commit`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$begin()
db$sendStatement("DELETE FROM mtcars WHERE gear = 3;")
db$clearResult()
db$commit()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$rollback`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$begin()
db$sendStatement("DELETE FROM mtcars WHERE gear = 3;")
db$clearResult()
db$rollback()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$getInfoDrv`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$getInfoDrv()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$getInfoCon`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$getInfoCon()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$getInfoRes`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
db$getInfoRes()
db$clearResult()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$isValidDrv`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$isValidDrv()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$isValidCon`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$isValidCon()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$isValidRes`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
db$isValidRes()
db$clearResult()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$validateCon`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$validateCon()
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$createTable`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$createTable("mtcars", mtcars)
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$appendTable`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$createTable("mtcars", mtcars)
db$appendTable("mtcars", mtcars)
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$writeTable`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$readTable`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
output <- db$readTable("mtcars")
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$removeTable`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$removeTable("mtcars")
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$existsTable`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$existsTable("mtcars")
db$disconnect()
db$unloadDriver()

## ------------------------------------------------
## Method `rocker$listFields`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$listFields("mtcars")
db$disconnect()

## ------------------------------------------------
## Method `rocker$listObjects`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$listObjects()
db$disconnect()

## ------------------------------------------------
## Method `rocker$listTables`
## ------------------------------------------------

db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$listTables()
db$disconnect()
}
\seealso{
Other rocker: 
\code{\link{newDB}()},
\code{\link{rocker-README}},
\code{\link{rocker-S3-functions}},
\code{\link{rocker-package}}
}
\concept{rocker}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{.drv}}{Read only \link[DBI:DBIDriver-class]{DBI::DBIDriver-class} object or NULL.
It is recommended not to use this object!
For advanced user, object can be used for direct execution of functions from DBI package.}

\item{\code{.con}}{Read only \link[DBI:DBIConnection-class]{DBI::DBIConnection-class} object or NULL.
It is recommended not to use this object!
For advanced user, object can be used for direct execution of functions from DBI package.}

\item{\code{.res}}{Read only \link[DBI:DBIResult-class]{DBI::DBIResult-class} object or NULL.
It is recommended not to use this object!
For advanced user, object can be used for direct execution of functions from DBI package.}

\item{\code{transaction}}{Read only TRUE or FALSE.
Information on pending transaction.}

\item{\code{info}}{Read only driver package and connection parameter information list.}

\item{\code{verbose}}{TRUE or FALSE. Switch text output on / off.}

\item{\code{id}}{Optional object ID/name}

\item{\code{validateQuery}}{SQL statement used in validateCon}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{rocker$new()}}
\item \href{#method-print}{\code{rocker$print()}}
\item \href{#method-setupDriver}{\code{rocker$setupDriver()}}
\item \href{#method-setupPostgreSQL}{\code{rocker$setupPostgreSQL()}}
\item \href{#method-setupMariaDB}{\code{rocker$setupMariaDB()}}
\item \href{#method-setupSQLite}{\code{rocker$setupSQLite()}}
\item \href{#method-unloadDriver}{\code{rocker$unloadDriver()}}
\item \href{#method-canConnect}{\code{rocker$canConnect()}}
\item \href{#method-connect}{\code{rocker$connect()}}
\item \href{#method-disconnect}{\code{rocker$disconnect()}}
\item \href{#method-sendQuery}{\code{rocker$sendQuery()}}
\item \href{#method-getQuery}{\code{rocker$getQuery()}}
\item \href{#method-sendStatement}{\code{rocker$sendStatement()}}
\item \href{#method-execute}{\code{rocker$execute()}}
\item \href{#method-fetch}{\code{rocker$fetch()}}
\item \href{#method-hasCompleted}{\code{rocker$hasCompleted()}}
\item \href{#method-getRowsAffected}{\code{rocker$getRowsAffected()}}
\item \href{#method-getRowCount}{\code{rocker$getRowCount()}}
\item \href{#method-columnInfo}{\code{rocker$columnInfo()}}
\item \href{#method-getStatement}{\code{rocker$getStatement()}}
\item \href{#method-clearResult}{\code{rocker$clearResult()}}
\item \href{#method-begin}{\code{rocker$begin()}}
\item \href{#method-commit}{\code{rocker$commit()}}
\item \href{#method-rollback}{\code{rocker$rollback()}}
\item \href{#method-getInfoDrv}{\code{rocker$getInfoDrv()}}
\item \href{#method-getInfoCon}{\code{rocker$getInfoCon()}}
\item \href{#method-getInfoRes}{\code{rocker$getInfoRes()}}
\item \href{#method-isValidDrv}{\code{rocker$isValidDrv()}}
\item \href{#method-isValidCon}{\code{rocker$isValidCon()}}
\item \href{#method-isValidRes}{\code{rocker$isValidRes()}}
\item \href{#method-validateCon}{\code{rocker$validateCon()}}
\item \href{#method-createTable}{\code{rocker$createTable()}}
\item \href{#method-appendTable}{\code{rocker$appendTable()}}
\item \href{#method-writeTable}{\code{rocker$writeTable()}}
\item \href{#method-readTable}{\code{rocker$readTable()}}
\item \href{#method-removeTable}{\code{rocker$removeTable()}}
\item \href{#method-existsTable}{\code{rocker$existsTable()}}
\item \href{#method-listFields}{\code{rocker$listFields()}}
\item \href{#method-listObjects}{\code{rocker$listObjects()}}
\item \href{#method-listTables}{\code{rocker$listTables()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Generate new instance of class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$new(verbose = TRUE, id = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbose}}{TRUE or FALSE. Switch text output on / off.}

\item{\code{id}}{Optional object ID/name}

\item{\code{...}}{Not used yet}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
New instance of class
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print object information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Invisible self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setupDriver"></a>}}
\if{latex}{\out{\hypertarget{method-setupDriver}{}}}
\subsection{Method \code{setupDriver()}}{
Setup database driver and define connection parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$setupDriver(drv, protect = c("password", "user"), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{drv}}{Driver object from suitable package e.g. \code{\link[RPostgres:Postgres]{RPostgres::Postgres()}}, \code{\link[RMariaDB:MariaDBDriver-class]{RMariaDB::MariaDB()}} and \code{\link[RSQLite:SQLite]{RSQLite::SQLite()}}}

\item{\code{protect}}{Parameters to be hidden}

\item{\code{...}}{Suitable parameters passed to \code{\link[DBI:dbConnect]{DBI::dbConnect()}} e.g. host, port, dbname, user and password}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupDriver(
  drv = RSQLite::SQLite(),
  dbname = ":memory:"
)
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setupPostgreSQL"></a>}}
\if{latex}{\out{\hypertarget{method-setupPostgreSQL}{}}}
\subsection{Method \code{setupPostgreSQL()}}{
Setup database driver and define connection parameters for PostgreSQL using \link[RPostgres:Postgres]{RPostgres} package.
Wrapper for setupDriver() function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$setupPostgreSQL(
  host = "127.0.0.1",
  port = "5432",
  dbname = "mydb",
  user = "postgres",
  password = "password",
  protect = c("password", "user"),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{host}}{Host name or IP number}

\item{\code{port}}{Port number}

\item{\code{dbname}}{Database name}

\item{\code{user}}{User name}

\item{\code{password}}{Password}

\item{\code{protect}}{Parameters to be hidden}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbConnect]{DBI::dbConnect()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupPostgreSQL(
  host = "127.0.0.1", port = "5432", dbname = "mydb",
  user = "postgres", password = "password"
)
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setupMariaDB"></a>}}
\if{latex}{\out{\hypertarget{method-setupMariaDB}{}}}
\subsection{Method \code{setupMariaDB()}}{
Setup database driver and define connection parameters for MariaDB using \link[RMariaDB:RMariaDB-package]{RMariaDB} package.
Wrapper for setupDriver() function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$setupMariaDB(
  host = "127.0.0.1",
  port = "3306",
  dbname = "mydb",
  user = "root",
  password = "password",
  protect = c("password", "user"),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{host}}{Host name or IP number}

\item{\code{port}}{Port number}

\item{\code{dbname}}{Database name}

\item{\code{user}}{User name}

\item{\code{password}}{Password}

\item{\code{protect}}{Parameters to be hidden}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbConnect]{DBI::dbConnect()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupMariaDB(
  host = "127.0.0.1", port = "3306", dbname = "mydb",
  user = "root", password = "password"
)
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setupSQLite"></a>}}
\if{latex}{\out{\hypertarget{method-setupSQLite}{}}}
\subsection{Method \code{setupSQLite()}}{
Setup database driver and define connection parameters for SQLite using \link[RSQLite:SQLite]{RSQLite} package.
Wrapper for setupDriver() function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$setupSQLite(dbname = ":memory:", protect = c("password", "user"), ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dbname}}{Database name}

\item{\code{protect}}{Parameters to be hidden}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbConnect]{DBI::dbConnect()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite(
  dbname = ":memory:"
)
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-unloadDriver"></a>}}
\if{latex}{\out{\hypertarget{method-unloadDriver}{}}}
\subsection{Method \code{unloadDriver()}}{
Reset database driver and connection parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$unloadDriver(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, suitable parameters passed to \code{\link[DBI:dbDriver]{DBI::dbUnloadDriver()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-canConnect"></a>}}
\if{latex}{\out{\hypertarget{method-canConnect}{}}}
\subsection{Method \code{canConnect()}}{
Test connection parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$canConnect(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, suitable parameters passed to \code{\link[DBI:dbCanConnect]{DBI::dbCanConnect()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE or FALSE
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$canConnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-connect"></a>}}
\if{latex}{\out{\hypertarget{method-connect}{}}}
\subsection{Method \code{connect()}}{
Establish database connection using stored parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$connect(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbConnect]{DBI::dbConnect()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-disconnect"></a>}}
\if{latex}{\out{\hypertarget{method-disconnect}{}}}
\subsection{Method \code{disconnect()}}{
Disconnect database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$disconnect(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbDisconnect]{DBI::dbDisconnect()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sendQuery"></a>}}
\if{latex}{\out{\hypertarget{method-sendQuery}{}}}
\subsection{Method \code{sendQuery()}}{
Send SQL query to database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$sendQuery(statement, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{statement}}{SQL query (\code{SELECT})}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbSendQuery]{DBI::dbSendQuery()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
output <- db$fetch()
db$clearResult()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getQuery"></a>}}
\if{latex}{\out{\hypertarget{method-getQuery}{}}}
\subsection{Method \code{getQuery()}}{
Retrieve SQL query from database.
Combination of functions sendQuery(), fetch() and clearResult().
If required, database is automatically connected and disconnected.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$getQuery(statement, n = -1, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{statement}}{SQL query (\code{SELECT})}

\item{\code{n}}{Number of record to be fetched at once. All records will be fetched.}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbSendQuery]{DBI::dbSendQuery()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Records
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
output <- db$getQuery("SELECT * FROM mtcars;")
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sendStatement"></a>}}
\if{latex}{\out{\hypertarget{method-sendStatement}{}}}
\subsection{Method \code{sendStatement()}}{
Send SQL statement to database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$sendStatement(statement, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{statement}}{SQL statement (\code{UPDATE, DELETE, INSERT INTO, ...})}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbSendStatement]{DBI::dbSendStatement()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendStatement("DELETE FROM mtcars WHERE gear = 3;")
db$clearResult()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-execute"></a>}}
\if{latex}{\out{\hypertarget{method-execute}{}}}
\subsection{Method \code{execute()}}{
Execute SQL statement in database.
Combination of functions execute and clearResult.
If required, database is automatically connected and disconnected.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$execute(statement, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{statement}}{SQL statement (\code{UPDATE, DELETE, INSERT INTO, ...})}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbSendStatement]{DBI::dbSendStatement()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Number of affected rows
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$execute("DELETE FROM mtcars WHERE gear = 3;")
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fetch"></a>}}
\if{latex}{\out{\hypertarget{method-fetch}{}}}
\subsection{Method \code{fetch()}}{
Fetch SQL query result from database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$fetch(n = -1, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of record to be fetched}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbFetch]{DBI::dbFetch()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Records
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
output <- db$fetch()
db$clearResult()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hasCompleted"></a>}}
\if{latex}{\out{\hypertarget{method-hasCompleted}{}}}
\subsection{Method \code{hasCompleted()}}{
Information whether all records were retrieved.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$hasCompleted(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbHasCompleted]{DBI::dbHasCompleted()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE or FALSE
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
output <- db$fetch(5)
db$hasCompleted()
db$clearResult()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getRowsAffected"></a>}}
\if{latex}{\out{\hypertarget{method-getRowsAffected}{}}}
\subsection{Method \code{getRowsAffected()}}{
Information on number of affected rows.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$getRowsAffected(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbGetRowsAffected]{DBI::dbGetRowsAffected()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Number of affected rows
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendStatement("DELETE FROM mtcars WHERE gear = 3;")
db$getRowsAffected()
db$clearResult()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getRowCount"></a>}}
\if{latex}{\out{\hypertarget{method-getRowCount}{}}}
\subsection{Method \code{getRowCount()}}{
Information on number of retrieved rows.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$getRowCount(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbGetRowCount]{DBI::dbGetRowCount()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Number of retrieved rows
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
output <- db$fetch()
db$getRowCount()
db$clearResult()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-columnInfo"></a>}}
\if{latex}{\out{\hypertarget{method-columnInfo}{}}}
\subsection{Method \code{columnInfo()}}{
Information on query result columns.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$columnInfo(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbColumnInfo]{DBI::dbColumnInfo()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Information table
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
db$columnInfo()
db$clearResult()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getStatement"></a>}}
\if{latex}{\out{\hypertarget{method-getStatement}{}}}
\subsection{Method \code{getStatement()}}{
Information on sent statement.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$getStatement(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbGetStatement]{DBI::dbGetStatement()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Statement text
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
db$getStatement()
db$clearResult()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clearResult"></a>}}
\if{latex}{\out{\hypertarget{method-clearResult}{}}}
\subsection{Method \code{clearResult()}}{
Clear query or statement result.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$clearResult(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbClearResult]{DBI::dbClearResult()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
output <- db$fetch()
db$clearResult()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-begin"></a>}}
\if{latex}{\out{\hypertarget{method-begin}{}}}
\subsection{Method \code{begin()}}{
Begin transaction.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$begin(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:transactions]{DBI::dbBegin()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$begin()
db$sendStatement("DELETE FROM mtcars WHERE gear = 3;")
db$clearResult()
db$commit()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-commit"></a>}}
\if{latex}{\out{\hypertarget{method-commit}{}}}
\subsection{Method \code{commit()}}{
Commit transaction.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$commit(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:transactions]{DBI::dbCommit()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$begin()
db$sendStatement("DELETE FROM mtcars WHERE gear = 3;")
db$clearResult()
db$commit()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rollback"></a>}}
\if{latex}{\out{\hypertarget{method-rollback}{}}}
\subsection{Method \code{rollback()}}{
Rollback transaction.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$rollback(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:transactions]{DBI::dbRollback()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$begin()
db$sendStatement("DELETE FROM mtcars WHERE gear = 3;")
db$clearResult()
db$rollback()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getInfoDrv"></a>}}
\if{latex}{\out{\hypertarget{method-getInfoDrv}{}}}
\subsection{Method \code{getInfoDrv()}}{
Information on driver object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$getInfoDrv(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbGetInfo]{DBI::dbGetInfo()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Information list
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$getInfoDrv()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getInfoCon"></a>}}
\if{latex}{\out{\hypertarget{method-getInfoCon}{}}}
\subsection{Method \code{getInfoCon()}}{
Information on connection object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$getInfoCon(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbGetInfo]{DBI::dbGetInfo()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Information list
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$getInfoCon()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getInfoRes"></a>}}
\if{latex}{\out{\hypertarget{method-getInfoRes}{}}}
\subsection{Method \code{getInfoRes()}}{
Information on result object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$getInfoRes(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbGetInfo]{DBI::dbGetInfo()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Information list
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
db$getInfoRes()
db$clearResult()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isValidDrv"></a>}}
\if{latex}{\out{\hypertarget{method-isValidDrv}{}}}
\subsection{Method \code{isValidDrv()}}{
Check driver object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$isValidDrv(onLostNull = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{onLostNull}}{TRUE or FALSE. If driver lost, set .drv to NULL}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbIsValid]{DBI::dbIsValid()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE or FALSE
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$isValidDrv()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isValidCon"></a>}}
\if{latex}{\out{\hypertarget{method-isValidCon}{}}}
\subsection{Method \code{isValidCon()}}{
Check connection object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$isValidCon(onLostNull = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{onLostNull}}{TRUE or FALSE. If connection lost, set .con to NULL}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbIsValid]{DBI::dbIsValid()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE or FALSE
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$isValidCon()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isValidRes"></a>}}
\if{latex}{\out{\hypertarget{method-isValidRes}{}}}
\subsection{Method \code{isValidRes()}}{
Check result object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$isValidRes(onLostNull = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{onLostNull}}{TRUE or FALSE. If result lost, set .res to NULL}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbIsValid]{DBI::dbIsValid()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE or FALSE
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$sendQuery("SELECT * FROM mtcars;")
db$isValidRes()
db$clearResult()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-validateCon"></a>}}
\if{latex}{\out{\hypertarget{method-validateCon}{}}}
\subsection{Method \code{validateCon()}}{
Check if an earlier opened connection is still open.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$validateCon(statement = NULL, onLostNull = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{statement}}{Optional SQL statement. If not set default validateQuery will be used.}

\item{\code{onLostNull}}{TRUE or FALSE. If connection lost, set .con to NULL}

\item{\code{...}}{Not used yet}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE or FALSE
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$validateCon()
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-createTable"></a>}}
\if{latex}{\out{\hypertarget{method-createTable}{}}}
\subsection{Method \code{createTable()}}{
Create empty formatted table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$createTable(name, fields, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Table name}

\item{\code{fields}}{Template data.frame}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbCreateTable]{DBI::dbCreateTable()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$createTable("mtcars", mtcars)
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-appendTable"></a>}}
\if{latex}{\out{\hypertarget{method-appendTable}{}}}
\subsection{Method \code{appendTable()}}{
Append data to table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$appendTable(name, value, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Table name}

\item{\code{value}}{Values data.frame}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbAppendTable]{DBI::dbAppendTable()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Number of appended rows invisibly
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$createTable("mtcars", mtcars)
db$appendTable("mtcars", mtcars)
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-writeTable"></a>}}
\if{latex}{\out{\hypertarget{method-writeTable}{}}}
\subsection{Method \code{writeTable()}}{
Write data to table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$writeTable(name, value, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Table name}

\item{\code{value}}{Values data.frame}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbWriteTable]{DBI::dbWriteTable()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-readTable"></a>}}
\if{latex}{\out{\hypertarget{method-readTable}{}}}
\subsection{Method \code{readTable()}}{
Read table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$readTable(name, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Table name}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbReadTable]{DBI::dbReadTable()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Table
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
output <- db$readTable("mtcars")
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-removeTable"></a>}}
\if{latex}{\out{\hypertarget{method-removeTable}{}}}
\subsection{Method \code{removeTable()}}{
Remove table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$removeTable(name, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Table name}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbRemoveTable]{DBI::dbRemoveTable()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisible self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$removeTable("mtcars")
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-existsTable"></a>}}
\if{latex}{\out{\hypertarget{method-existsTable}{}}}
\subsection{Method \code{existsTable()}}{
Check if table exists.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$existsTable(name, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Table name}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbExistsTable]{DBI::dbExistsTable()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE or FALSE
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$existsTable("mtcars")
db$disconnect()
db$unloadDriver()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-listFields"></a>}}
\if{latex}{\out{\hypertarget{method-listFields}{}}}
\subsection{Method \code{listFields()}}{
List table column names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$listFields(name, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Table name}

\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbListFields]{DBI::dbListFields()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Column names
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$listFields("mtcars")
db$disconnect()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-listObjects"></a>}}
\if{latex}{\out{\hypertarget{method-listObjects}{}}}
\subsection{Method \code{listObjects()}}{
List database objects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$listObjects(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbListObjects]{DBI::dbListObjects()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of objects
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$listObjects()
db$disconnect()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-listTables"></a>}}
\if{latex}{\out{\hypertarget{method-listTables}{}}}
\subsection{Method \code{listTables()}}{
List database tables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{rocker$listTables(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Optional, additional suitable parameters passed to \code{\link[DBI:dbListTables]{DBI::dbListTables()}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
List of objects
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{db <- rocker::newDB()
db$setupSQLite()
db$connect()
db$writeTable("mtcars", mtcars)
db$listTables()
db$disconnect()
}
\if{html}{\out{</div>}}

}

}
}
