% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orcid_researcher_urls.R
\name{orcid_researcher_urls}
\alias{orcid_researcher_urls}
\title{Get researcher urls for a person}
\usage{
orcid_researcher_urls(orcid, put_code = NULL,
  format = "application/json", ...)
}
\arguments{
\item{orcid}{(character) Orcid identifier(s), of the form
XXXX-XXXX-XXXX-XXXX. required.}

\item{put_code}{(character/integer) one or more put codes. up to
50. optional}

\item{format}{(character) Name of the content-type format. One of
"application/vnd.orcid+xml; qs=5", "application/orcid+xml; qs=3",
"application/xml", "application/vnd.orcid+json; qs=4",
"application/orcid+json; qs=2", "application/json"
"application/vnd.citationstyles.csl+json". optional}

\item{...}{Curl options passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\value{
A list of results for each Orcid ID passed in, with each element
named by the Orcid ID
}
\description{
Get researcher urls for a person
}
\details{
This function is vectorized, so you can pass in many ORCID's, and
there's an element returned for each ORCID you put in.
}
\examples{
\dontrun{
# all data
res <- orcid_researcher_urls(orcid = "0000-0003-1444-9135")
res$`0000-0003-1444-9135`
names(res$`0000-0003-1444-9135`)
res$`0000-0003-1444-9135`$`researcher-url`

# individual ones
orcid_researcher_urls("0000-0003-1444-9135", 304093)
orcid_researcher_urls("0000-0003-1444-9135", c(332241, 304093))

# formats
orcid_researcher_urls("0000-0003-1444-9135", 304093, 
  format = "application/xml")
}
}
