% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orcid_citations.R
\name{orcid_citations}
\alias{orcid_citations}
\title{Get citations}
\usage{
orcid_citations(
  orcid,
  put_code = NULL,
  cr_format = "bibtex",
  cr_style = "apa",
  cr_locale = "en-US",
  ...
)
}
\arguments{
\item{orcid}{(character) Orcid identifier(s) of the form
XXXX-XXXX-XXXX-XXXX. required.}

\item{put_code}{(character/integer) one or more put codes. up to
50. optional}

\item{cr_format}{Used in Crossref queries only. Name of the format. One of
"rdf-xml", "turtle",
"citeproc-json", "citeproc-json-ish", "text", "ris", "bibtex" (default),
"crossref-xml", "datacite-xml","bibentry", or "crossref-tdm". The format
"citeproc-json-ish" is a format that is not quite proper citeproc-json.
passed to \code{rcrossref::cr_cn}. The special "citeproc2bibtex" value asks
for citeproc-json from Crossref, then converts it into bibtex format
using \link[handlr:HandlrClient]{handlr::HandlrClient}}

\item{cr_style}{Used in Crossref queries only. A CSL style (for text
format only). See 'get_styles()' for options. Default: apa.
passed to \code{rcrossref::cr_cn}}

\item{cr_locale}{Used in Crossref queries only. Language locale.
See \link{Sys.getlocale}, passed to \code{rcrossref::cr_cn}}

\item{...}{Curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
A list of results for each Orcid ID passed in, with each element
named by the Orcid ID

data.frame, with the columns:
\itemize{
\item put: ORCID PUT code, identifying the work identifier in ORCID's records
\item id: the external identifier
\item id_type: the type of external identifier
\item format: the citation format retrieved
\item citation: the citation as JSON
}
}
\description{
Get citations
}
\details{
This function is vectorized, so you can pass in many ORCID's, and
there's an element returned for each ORCID you put in.

This function is focused on getting citations only.
You can get all citations for an ORCID, or for certain works
using a PUT code, or for many PUT codes.

We attempt to get citations via Crossref using \pkg{rcrossref}
whenever possible as they are the most flexible and don't have as
many mistakes in the text. If there is no DOI, we fetch the
citation from ORCID.

Right now we get JSON citations back. We'd like to support bibtex
format. DOI.org supports this but not ORCID.
}
\examples{
\dontrun{
(res <- orcid_citations(orcid = "0000-0002-9341-7985"))
(res2 <- orcid_citations(orcid = "0000-0002-1642-628X"))
(res2 <- orcid_citations(orcid = c("0000-0002-9341-7985", "0000-0002-1642-628X")))

# get individual works
## a single put code
(a <- orcid_citations(orcid = "0000-0002-9341-7985", put_code = 5011717))
## many put codes
(b <- orcid_citations(orcid = "0000-0002-9341-7985",
   put_code = c(5011717, 15536016)))

# request other formats, Crossref only
orcid_citations(orcid = "0000-0002-9341-7985", cr_format = "turtle")

# parse citation data if you wish
# for parsing bibtex can use bibtex package or others
(res <- orcid_citations(orcid = "0000-0002-9341-7985"))
lapply(res[res$format == "csl-json", "citation"][[1]], jsonlite::fromJSON)

# lots of citations
orcid_citations(orcid = "0000-0001-8642-6325")

# example with no external identifier, returns NA's
orcid_citations(orcid = "0000-0001-8642-6325", 26222265)
}
}
