% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemm.R
\name{gemm}
\alias{gemm}
\title{Analyze moderated mediation model using SEM}
\usage{
gemm(
  data = NULL,
  xvar,
  mvars,
  yvar,
  xmmod = NULL,
  mymod = NULL,
  cmvars = NULL,
  cyvars = NULL,
  estMethod = "bootstrap",
  nboot = 1000
)
}
\arguments{
\item{data}{data frame}

\item{xvar}{predictor variable, must be either numerical or dichotomous}

\item{mvars}{vector of names of mediator variables}

\item{yvar}{dependent variable, must be numerical}

\item{xmmod}{moderator of effect predictor on mediators, must be either numerical or dichotomous}

\item{mymod}{moderator of effect mediators on dependent variable, must be either numerical or dichotomous}

\item{cmvars}{covariates for mediators}

\item{cyvars}{covariates for dependent variable}

\item{estMethod}{estimation of standard errors method, bootstrap is default}

\item{nboot}{number of bootstrap samples}
}
\value{
gemm object
}
\description{
Analyze moderated mediation model using SEM
}
\examples{
\dontrun{
data("cpbExample")
       res <- gemm(dat = cpbExample, xvar="procJustice", mvars= c("cynicism","trust"),
       yvar = "CPB", nboot=500)
print(res)
}
}
