% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve.R
\name{solve_osqp}
\alias{solve_osqp}
\title{Sparse Quadratic Programming Solver}
\usage{
solve_osqp(P = NULL, q = NULL, A = NULL, l = NULL, u = NULL,
  pars = osqpSettings())
}
\arguments{
\item{P, A}{sparse matrices of class dgCMatrix or coercible into such, with P positive semidefinite.}

\item{q, l, u}{Numeric vectors, with possibly infinite elements in l and u}

\item{pars}{list with optimization parameters, conveniently set with the function \code{osqpSettings}}
}
\value{
A list with elements x (the primal solution), y (the dual solution), prim_inf_cert, 
dual_inf_cert, and info.
}
\description{
Solves \deqn{arg\min_x 0.5 x'P x + q'x}{argmin_x 0.5 x'P x + q'x}
s.t. \deqn{l_i < (A x)_i < u_i}{li < (A x)i < ui}
for real matrices P (nxn, positive semidefinite) and A (mxn) with m number of constraints
}
\examples{
library(rosqp)
## example, adapted from ?quadprog::solve.QP
Dmat       <- diag(3)
dvec       <- c(0,-5,0)
Amat       <- matrix(c(-4, 2, 0, -3, 1, -2, 0, 0, 1),3,3)
bvec       <- c(-8,2,0)
res = solve_osqp(Dmat, dvec, Amat, bvec)
print(res$x)



}
\references{
{
Stellato, B., Banjac, G., Goulart, P., Bemporad, A., Boyd and S. (2017).
``OSQP: An Operator Splitting Solver for Quadratic Programs.''
\emph{ArXiv e-prints}.
1711.08013.}
}
\seealso{
\code{\link{osqp}}. The underlying OSQP documentation: \url{http://osqp.readthedocs.io/}
}
