% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/taxonomy.R
\name{taxonomy_lica}
\alias{ott_id.taxon_lica}
\alias{ott_taxon_name.taxon_lica}
\alias{tax_rank.taxon_lica}
\alias{taxonomy_lica}
\title{Taxonomic LICA}
\usage{
taxonomy_lica(ott_ids = NULL, ...)

\method{tax_rank}{taxon_lica}(tax)

\method{ott_taxon_name}{taxon_lica}(tax)

\method{ott_id}{taxon_lica}(tax, ...)
}
\arguments{
\item{ott_ids}{a vector of ott ids for the taxa whose LICA is to
be found (numeric).}

\item{...}{additional arguments to customize the API request (see
\code{\link{rotl}} package documentation).}

\item{tax}{an object generated by the \code{taxonomy_lica}
function}
}
\value{
\itemize{

    \item{\code{taxonomy_lica}} { returns a list about the
    taxonomic information relating to the LICA for the ott_ids
    provided. }

    \item{\code{tax_rank}} { returns a character vector of the
    taxonomic rank for the LICA. }

    \item{\code{ott_taxon_name}} { returns a character vector the
    Open Tree Taxonomy name for the LICA. }

    \item{\code{ott_id}} { returns a numeric vector of the ott id
    for the LICA. }

}
}
\description{
Taxonomic Least Inclusive Common Ancestor
}
\details{
Given a set of ott ids, get the taxon that is the least inclusive common ancestor
(the LICA) of all the identified taxa. A taxonomic LICA is analogous to a most recent
common ancestor (MRCA) in a phylogenetic tree.
}
\examples{
\dontrun{
req <- taxonomy_lica(ott_ids=c(515698,590452,409712,643717))
tax_rank(req)
ott_taxon_name(req)
ott_id(req)
}
}

