% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_names.R
\name{synonyms.match_names}
\alias{synonyms.match_names}
\title{List the synonyms for a given name}
\usage{
\method{synonyms}{match_names}(tax, row_number, taxon_name, ott_id,
  only_current = TRUE, ...)
}
\arguments{
\item{tax}{a data frame generated by the
\code{\link{tnrs_match_names}} function}

\item{row_number}{the row number corresponding to the name for
which to list the synonyms}

\item{taxon_name}{the taxon name corresponding to the name for
which to list the synonyms}

\item{ott_id}{the ott id corresponding to the name for which to
list the synonyms}

\item{only_current}{logical (default \code{TRUE}), should the
results include data for all matched names, or only the one
listed in the object returned by
\code{\link{tnrs_match_names}}?}

\item{...}{currently ignored}
}
\value{
a list whose elements are all synomym names (as vectors of
    character) for the taxonomic names that match the query (the
    names of the elements of the list).
}
\description{
When querying the Taxonomic Name Resolution Services for a
particular taxonomic name, the API returns as possible matches all
names that include the queried name as a possible synonym. This
function allows you to explore other synonyms for an accepted
name, and allows you to determine why the name you queried is
returning an accepted synonym.
}
\details{
To list synonyms for a given taxonomic name, you need to provide
the object resulting from a call to the
\code{\link{tnrs_match_names}} function, as well as one of either
the row number corresponding to the name in this object, the name
itself (as used in the original query), or the ott_id listed for
this name. Otherwise, the synonyms for all the currently matched
names are returned. Using \code{only_current = FALSE} will return
all synonyms for all possible matches.
}
\examples{
\dontrun{
   echino <- tnrs_match_names(c("Diadema", "Acanthaster", "Fromia"))
   ## These 3 calls are identical
   synonyms(echino, taxon_name="Acanthaster")
   synonyms(echino, row_number=2)
   synonyms(echino, ott_id=337928)
}
}

