% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route.R
\docType{data}
\name{Route}
\alias{Route}
\title{Create a route for dispatching on URL}
\description{
The \code{Route} class is used to encapsulate a single URL dispatch, that is,
chose a single handler from a range based on a URL path. A handler will be
called with a request, response, and keys argument as well as any additional
arguments passed on to \code{dispatch()}.
}
\details{
The path will strip the query string prior to assignment of the handler, can
contain wildcards, and can be parameterised using the \code{:} prefix. If there
are multiple matches of the request path the most specific will be chosen.
Specificity is based on number of elements (most), number of parameters
(least), and number of wildcards (least), in that order. Parameter
values will be available in the keys argument passed to the handler, e.g. a
path of \code{/user/:user_id} will provide \code{list(user_id = 123)} for a dispatch on
\code{/user/123} in the \code{keys} argument.

Handlers are only called for their side-effects and are expected to return
either \code{TRUE} or \code{FALSE} indicating whether additional routes in a
\code{\link{RouteStack}} should be called, e.g. if a handler is returning \code{FALSE} all
further processing of the request will be terminated and the response will be
passed along in its current state. Thus, the intend of the handlers is to
modify the request and response objects, in place. All calls to handlers will
be wrapped in \code{\link[=try]{try()}} and if an exception is raised the response code will be
set to \code{500} with the body of the response being the error message. Further
processing of the request will be terminated. If a different error handling
scheme is wanted it must be implemented within the handler (the standard
approach is chosen to avoid handler errors resulting in a server crash).

A handler is referencing a specific HTTP method (\code{get}, \code{post}, etc.) but can
also reference \code{all} to indicate that it should match all types of requests.
Handlers referencing \code{all} have lower precedence than those referencing
specific methods, so will only be called if a match is not found within the
handlers of the specific method.
}
\section{Initialization}{

A new 'Route'-object is initialized using the \code{new()} method on the
generator:

\strong{Usage}
\tabular{l}{
\code{route <- Route$new(...)}
}

\strong{Arguments}
\tabular{lll}{
\code{...} \tab  \tab Handlers to add up front. Must be in the form of named
lists where the names corresponds to paths and the elements are the handlers.
The name of the argument itself defines the method to listen on (see examples)
}
}

\section{Methods}{

The following methods are accessible in a \code{Route} object:

\describe{
\item{\code{add_handler(method, path, handler)}}{Add a handler to the specified
method and path. The special method \code{'all'} will allow the handler to match
all http request methods. The path is a URL path consisting of strings,
parameters (strings prefixed with \code{:}), and wildcards (\code{*}), separated by
\code{/}. A wildcard will match anything and is thus not restricted to a single
path element (i.e. it will span multiple \code{/} if possible). The handler must
be a function containing the arguments \code{request}, \code{response}, \code{keys}, and
\code{...}, and must return either \code{TRUE} or \code{FALSE}. The \code{request} argument will
be a \link[reqres:Request]{reqres::Request} object and the \code{response} argument will be a
\link[reqres:Response]{reqres::Response} object matching the current exchange. The \code{keys} argument
will be a named list with the value of all matched parameters from the path.
Any additional argument passed on to the \code{dispatch} method will be avaiable
as well. This method will override an existing handler with the same method
and path.}
\item{\code{remove_handler(method, path)}}{Removes the handler assigned to the
specified method and path. If no handler have been assigned it will throw a
warning.}
\item{\code{dispatch(request, ...)}}{Based on a \link[reqres:Request]{reqres::Request} object the
route will find the correct handler and call it with the correct arguments.
Anything passed in with \code{...} will be passed along to the handler.}
}
}

\examples{
# Initialise an empty route
route <- Route$new()

# Initialise a route with handlers assigned
route <- Route$new(
  all = list(
    '/*' = function(request, response, keys, ...) {
      message('Request recieved')
      TRUE
    }
  )
)

# Remove it again
route$remove_handler('all', '/*')

}
\seealso{
\link{RouteStack} for binding multiple routes sequentially
}
\keyword{datasets}
