library("rpatrec")
context("functionality of the interpret() function")

test_that("Function recognises a simple HS pattern and the included double bottom",{
  a <- generator()
  b <- interpret(a)
  c <- a * (-1)
  d <- interpret(c)
  expect_equal(b$EXT,c(1,0,1,0,1))
  expect_equal(round(b$HSP$HS[5]),50)
  expect_equal(round(b$DTP$DBOT[2]),100)
  expect_equal(d$EXT,c(0,1,0,1,0))
  expect_equal(round(d$HSP$InHS[5]),-50)
  expect_equal(round(d$DTP$DTOP[2]),-100)
})

test_that("Function recognises a rectangle top and the included double top",{
  a <- generator(plength=5,parts=c(0,20,40,50,60,80,100),sprd=c(0,80,40,80,40,80,0))
  b <- interpret(a)
  c <- a * (-1)
  d <- interpret(c)
  expect_equal(b$EXT,c(1,0,1,0,1))
  expect_equal(round(b$RTP$RTOP[5]),80)
  expect_equal(round(b$DTP$DTOP[2]),40)
  expect_equal(d$EXT,c(0,1,0,1,0))
  expect_equal(round(d$RTP$RBOT[5]),-80)
  expect_equal(round(d$DTP$DBOT[2]),-40)
})
