\name{label.branches}
\alias{label.branches}
\title{Label tree branches}
\usage{
  label.branches(tree, branches, label)
}
\arguments{
  \item{tree}{A vector of character strings, each
  containing a newick tree}

  \item{branches}{A vector of character strings, indicating
  the branches which should get the label.  The branch is
  named by the node which descends from it.  If multiple
  trees and branches are given, all named branches will be
  labelled in every tree.}

  \item{label}{A single character string giving the label
  to apply to the named branches.}
}
\value{
  A vector of character strings containing the modified
  trees; the branches are labelled by appending a pound
  sign and the label to the node name in the tree string.
}
\description{
  Apply a label to some branches
}
\examples{
trees <- c("((hg18:1.0, panTro2:2.0)hg18-panTro2:3.0, mm9:4.0);",
           "((hg18:0.142679,(mm9:0.083220,rn4:0.090564)mm9-rn4:
             0.269385)hg18-rn4:0.020666,canFam2:0.193569);")
label.branches(trees, c("hg18", "mm9"), "humanAndMouse")
}
\author{
  Melissa J. Hubisz
}
\keyword{trees}

