% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/bgc.R
\name{phastBias}
\alias{phastBias}
\title{phastBias}
\usage{
phastBias(align, mod, foreground = NULL, do.bgc = TRUE, bgc = 3,
  estimate.bgc = FALSE, bgc.expected.length = 1000,
  estimate.bgc.expected.length = FALSE, bgc.target.coverage = 0.01,
  estimate.bgc.target.coverage = TRUE, sel = -2.01483,
  cons.expected.length = 45, cons.target.coverage = 0.3,
  estimate.scale = FALSE, post.probs = TRUE)
}
\arguments{
\item{align}{An msa object representing an alignment}

\item{mod}{An object of type \code{tm} representing the neutral
nucleotide substitution model.}

\item{foreground}{A character string giving the name of a branch (or
a label given to several branches) indicating which branch should be
in the foreground.  The foreground branch is where gBGC is tested.}

\item{do.bgc}{If \code{FALSE}, do not model GC-biased gene conversion}

\item{bgc}{Initial value for gBGC parameter B}

\item{estimate.bgc}{If \code{FALSE}, do not optimize the gBGC parameter,
just hold it at its initial value.}

\item{bgc.expected.length}{Initial value for expected length of gBGC
tract lengths.}

\item{estimate.bgc.expected.length}{If \code{FALSE}, do not optimize
the transition rate out of gBGC states (which determines the distribution
of gBGC tract lengths)}

\item{bgc.target.coverage}{Initial value for prior expected target
coverage of gBGC tracts (as a fraction between 0 and 1).}

\item{estimate.bgc.target.coverage}{If \code{FALSE}, constrain the rates
into and out of gBGC state so that bgc.target.coverage does not change.}

\item{sel}{Set the scaling factor for the conserved state. This is a
population genetic parameter which translates to a scaling factor of
sel/(1-exp(-sel)). The default value of s=-2.01483 translates to a
scaling factor of 0.31 in the background branches.}

\item{cons.expected.length}{Set the expected length of conserved
elements.}

\item{cons.target.coverage}{Set the target coverage for conserved
elements.}

\item{estimate.scale}{If \code{TRUE}, estimate a scaling factor for the
branch lengths in all states.}

\item{post.probs}{If \code{TRUE}, return value will include a data frame
containing posterior probabilities for every position in the alignment
and every state.  Set to \code{FALSE} to suppress.}
}
\value{
A list containing parameter estimates, a features object
predicting which part of the alignments have gBGC probability > 0.5,
and a data frame with posterior probabilities at all positions (if
post.probs==TRUE)
}
\description{
PhastBias performs a phylo-HMM analysis which assesses the evidence
for GC-biased gene conversion (gBGC) on a particular branch of the tree.
}
\details{
PhastBias utilizes a HMM with the following states: neutral, conserved,
neutral with gBGC, and conserved with gBGC.  The scaling factor between
conserved/neutral, the strength of gBGC, and the transition rates between
states can be configured.  It produces posterior probabilities for each
state for every column of the alignment, or a set of gBGC "tracts"
giving the regions where gBGC is predicted (by thresholding the posterior
probability at 0.5).
}
\author{
Melissa J. Hubisz
}

