% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plosviews}
\alias{plosviews}
\title{Search PLoS Journals by article views.}
\usage{
plosviews(search, byfield = NULL, views = "alltime", limit = NULL,
  key = getOption("PlosApiKey", stop("need an API key for PLoS Journals")),
  callopts = list(), curl = getCurlHandle())
}
\arguments{
\item{search}{search terms (character)}

\item{byfield}{field to search by, e.g., subject, author, etc. (character)}

\item{views}{views all time (alltime) or views last 30 days (last30)
(character)}

\item{limit}{number of results to return (integer)}

\item{key}{your PLoS API key, either enter, or loads from .Rprofile}

\item{callopts}{Optional additional curl options (debugging tools mostly)}

\item{curl}{If using in a loop, call getCurlHandle() first and pass
the returned value in here (avoids unnecessary footprint)}
}
\description{
Search PLoS Journals by article views.
}
\examples{
\dontrun{
plosviews('10.1371/journal.pone.0002154', 'id', 'alltime')
plosviews('10.1371/journal.pone.0002154', 'id', 'last30')
plosviews('10.1371/journal.pone.0002154', 'id', 'alltime,last30')
plosviews(search='marine ecology', byfield='subject', limit=50)
plosviews(search='evolution', views = 'alltime', limit = 99)
plosviews('bird', views = 'alltime', limit = 99)
}
}

