% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_db_wrapper_fns.R
\name{dbAddKey}
\alias{dbAddKey}
\title{Add key.}
\usage{
dbAddKey(
  conn,
  name,
  colname,
  type = c("primary", "foreign"),
  reference,
  colref,
  display = TRUE,
  exec = TRUE
)
}
\arguments{
\item{conn}{A connection object.}

\item{name}{A character string, or a character vector, specifying
a PostgreSQL table name.}

\item{colname}{A character string specifying the name of the
column to which the key will be assign; alternatively, a
character vector specifying the name of the columns for keys
spanning more than one column.}

\item{type}{The type of the key, either \code{"primary"} or
\code{"foreign"}}

\item{reference}{A character string specifying a foreign table
name to which the foreign key will be associated (ignored if
\code{type == "primary"}).}

\item{colref}{A character string specifying the name of the
primary key in the foreign table to which the foreign key will
be associated; alternatively, a character vector specifying
the name of the columns for keys spanning more than one column
(ignored if \code{type == "primary"}).}

\item{display}{Logical. Whether to display the query (defaults to
\code{TRUE}).}

\item{exec}{Logical. Whether to execute the query (defaults to
\code{TRUE}).}
}
\value{
If \code{exec = TRUE}, returns \code{TRUE} if the key was successfully added.
}
\description{
Add a primary or foreign key to a table column.
}
\examples{
## Examples use a dummy connection from DBI package
conn <- DBI::ANSI()

## Primary key
dbAddKey(conn, name = c("sch1", "tbl1"), colname = "id1", exec = FALSE)

## Primary key using multiple columns
dbAddKey(conn, name = c("sch1", "tbl1"), colname = c("id1", "id2",
    "id3"), exec = FALSE)

## Foreign key
dbAddKey(conn, name = c("sch1", "tbl1"), colname = "id", type = "foreign",
    reference = c("sch2", "tbl2"), colref = "id", exec = FALSE)

## Foreign key using multiple columns
dbAddKey(conn, name = c("sch1", "tbl1"), colname = c("id1", "id2"),
    type = "foreign", reference = c("sch2", "tbl2"), colref = c("id3",
        "id4"), exec = FALSE)
}
\seealso{
The PostgreSQL documentation:
    \url{http://www.postgresql.org/docs/current/static/sql-altertable.html}
}
\author{
Mathieu Basille \email{mathieu@basille.org}
}
