% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ants-plot.R
\name{ants_plot_grid}
\alias{ants_plot_grid}
\title{Plot multiple \code{'ANTsImage'}}
\usage{
ants_plot_grid(
  images,
  shape = NULL,
  slices = 0,
  axes = 2,
  figsize = 1,
  rpad = 0,
  cpad = 0,
  vmin = NULL,
  vmax = NULL,
  colorbar = TRUE,
  cmap = "Greys_r",
  title = "",
  tfontsize = 20,
  title_dx = 0,
  title_dy = 0,
  rlabels = NULL,
  rfontsize = 14,
  rfontcolor = "black",
  rfacecolor = "white",
  clabels = NULL,
  cfontsize = 14,
  cfontcolor = "black",
  cfacecolor = "white",
  filename = NULL,
  dpi = 400,
  transparent = TRUE,
  ...,
  force_agg = FALSE,
  close_figure = TRUE
)
}
\arguments{
\item{images}{a single \code{'ANTsImage'}, list, or nested list of \code{'ANTsImage'}}

\item{shape}{shape of grid, default is using dimensions of \code{images}}

\item{slices}{length of one or equaling to length of \code{slices}, slice
number to plot}

\item{axes}{\code{0} for \code{'sagittal'}, \code{1} for \code{'coronal'},
\code{2} for \code{'axial'}; default is \code{2}}

\item{figsize, rpad, cpad, colorbar, cmap, transparent}{graphical parameters}

\item{vmin, vmax}{value threshold for the image}

\item{title}{title of figure}

\item{title_dx, title_dy, tfontsize}{controls title margin and size}

\item{rlabels, clabels}{row and column labels}

\item{rfontsize, rfontcolor, rfacecolor, cfontsize, cfontcolor, cfacecolor}{row
and column font size, color, and background color}

\item{filename, dpi}{parameters to save figures}

\item{...}{passed to \code{ants$plot_grid}; make sure all entries are named}

\item{force_agg}{whether to force graphic engine to use \code{'agg'} device;
default is false}

\item{close_figure}{whether to close figure when returning the function}
}
\value{
Nothing
}
\description{
R-friendly wrapper function for \code{ants$plot_grid}
}
\examples{

if(interactive() && ants_available()) {
  ants <- load_ants()
  image1 <- ants$image_read(ants$get_ants_data('mni'))
  image2 <- image1$smooth_image(1.0)
  image3 <- image1$smooth_image(2.0)
  image4 <- image1$smooth_image(3.0)

  ants_plot_grid(
    list(image1, image2, image3, image4),
    slices = 100, title = "4x1 Grid"
  )

  ants_plot_grid(
    list(image1, image2, image3, image4),
    shape = c(2, 2),
    slices = 100, title = "2x2 Grid"
  )
  ants_plot_grid(
    list(image1, image2, image3, image4),
    shape = c(2, 2), axes = c(0,1,2,1),
    slices = 100, title = "2x2 Grid (diff. anatomical slices)"
  )

}



}
