% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{conda-env}
\alias{conda-env}
\alias{CONDAENV_NAME}
\alias{conda_path}
\alias{conda_bin}
\alias{env_path}
\alias{list_pkgs}
\alias{configure_matlab}
\alias{configure_conda}
\alias{remove_conda}
\alias{add_packages}
\alias{ensure_rpymat}
\alias{matlab_engine}
\alias{call_matlab}
\title{'Miniconda' environment}
\usage{
CONDAENV_NAME(env_name)

conda_path()

conda_bin()

env_path()

list_pkgs(...)

configure_matlab(matlab, python_ver = "auto")

configure_conda(
  python_ver = "auto",
  packages = NULL,
  matlab = NULL,
  update = FALSE,
  force = FALSE,
  standalone = FALSE
)

remove_conda(ask = TRUE)

add_packages(packages = NULL, python_ver = "auto", ...)

ensure_rpymat(verbose = TRUE, cache = TRUE)

matlab_engine()

call_matlab(
  fun,
  ...,
  .options = getOption("rpymat.matlab_opt", "-nodesktop -nojvm"),
  .debug = getOption("rpymat.debug", FALSE)
)
}
\arguments{
\item{env_name}{alternative environment name to use; default is
\code{"rpymat-conda-env"}}

\item{...}{for \code{add_packages}, these are additional parameters
passing to \code{\link[reticulate]{conda_install}}; for
\code{call_matlab}, \code{...} are the parameters passing to \code{fun}}

\item{matlab}{'Matlab' path to add to the configuration path;
see 'Details'}

\item{python_ver}{\code{python} version to use; see 'Configuration'}

\item{packages}{additional \code{python} or \code{conda} packages to install}

\item{update}{whether to update \code{conda}; default is false}

\item{force}{whether to force install the 'Miniconda' even a previous
version exists; default is false. Setting \code{false=TRUE} rarely
works. Please see 'Configuration'.}

\item{standalone}{whether to install \code{conda} regardless of existing
\code{conda} environment}

\item{ask}{whether to ask for user's agreement to remove the repository.
This parameter should be true if your functions depend on
\code{remove_conda} (see 'CRAN Repository Policy'). This argument might
be removed and force to be interactive in the future.}

\item{verbose}{whether to print messages}

\item{cache}{whether to use cached configurations; default is true}

\item{fun}{'Matlab' function name, character (experimental)}

\item{.options}{'Matlab' compiler options}

\item{.debug}{whether to enable debug mode}
}
\value{
None
}
\description{
These functions/variables are used to configure
'Miniconda' environment.
}
\section{Background & Objectives}{

Package \code{reticulate} provides sophisticated tool-sets that
allow us to call \code{python} functions within \code{R}. However, the
installation of 'Miniconda' and \code{python} can be tricky on many
platforms, for example, the 'M1' chip, or some other 'ARM' machines.
The package \code{rpymat} provides easier approach to configure on these
machines with totally isolated environments. Any modifications to this
environment will not affect your other set ups.

Since 2014, 'Matlab' has introduced its official compiler for \code{python}.
The package \code{rpymat} provides a simple approach to link the
compiler, provided that you have proper versions of 'Matlab' installed.
\href{https://www.mathworks.com/support/requirements/python-compatibility.html}{Here} is a list of
'Matlab' versions with official compilers and their corresponding
\code{python} versions.
}

\section{Configuration}{

If 'Matlab' compiler is not to be installed, In most of the cases,
function \code{configure_conda} with default arguments automatically
downloads the latest 'Miniconda' and configures the latest \code{python}.
If any other versions of 'Miniconda' is ought to be installed,
please set options \code{"reticulate.miniconda.url"} to change the
source location.

If 'Matlab' is to be installed, please specify the 'Matlab' path when
running \code{configure_conda}. If the environment has been setup,
\code{configure_matlab} can link the 'Matlab' compilers without
removing the existing environment. For 'ARM' users, unfortunately,
there will be no 'Matlab' support as the compilers are written for
the 'Intel' chips.
}

\section{Initialization}{

Once \code{conda} and \code{python} environment has been installed, make sure
you run \code{ensure_rpymat()} before running any \code{python} code. This
function will make sure correct compiler is linked to your current
\code{R} session.
}

\examples{

# The script will interactively install \code{conda} to `R_user_dir`
\dontrun{

# Install conda and python 3.9

configure_conda(python_ver = '3.9')


# Add packages h5py, pandas, jupyter

add_packages(c('h5py', 'pandas', 'jupyter'))

# Add pip packages

add_packages("itk", pip = TRUE)

# Initialize the isolated environment

ensure_rpymat()


# Remove the environment

remove_conda()

}

}
