% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ex_data_frame.R
\name{rquery_apply_to_data_frame}
\alias{rquery_apply_to_data_frame}
\title{Execture node_tree in an enviroment where d is the only data.}
\usage{
rquery_apply_to_data_frame(pipe_left_arg, pipe_right_arg,
  pipe_environment = parent.frame(), result_limit = NULL)
}
\arguments{
\item{pipe_left_arg}{data.frame}

\item{pipe_right_arg}{rquery rel_op operation tree.}

\item{pipe_environment}{environment to look for "winvector_temp_db_handle" in.}

\item{result_limit}{numeric if not null limit result to this many rows.}
}
\value{
data.frame result
}
\description{
Default DB uses RSQLite (so some functions are not supported).
Functionality is through \code{"wrapr_applicable"}: \url{https://winvector.github.io/wrapr/articles/wrapr_applicable.html}.
}
\examples{

winvector_temp_db_handle <- list(
  db = DBI::dbConnect(RSQLite::SQLite(), ":memory:")
)
RSQLite::initExtension(winvector_temp_db_handle$db)

d <- data.frame(AUC = 0.6, R2 = c(0.1, 0.2), D = NA, z = 2)
q <- table_source("d", c("AUC", "R2", "D")) \%.>\%
	extend_nse(., c := sqrt(R2)) \%.>\%
  orderby(., "R2", desc = TRUE)

rquery_apply_to_data_frame(d, q)

execute_data_frame(q, data = d)

d \%.>\% q
# run (and build result for) ad-hoc query
d \%.>\%
  extend_nse(., c := sqrt(R2)) \%.>\%
  orderby(., "R2", desc = TRUE) \%.>\%
  execute_data_frame(.)
# print ad-hoc query (result only available for printing)
d \%.>\%
  extend_nse(., c := sqrt(R2)) \%.>\%
  orderby(., "R2", desc = TRUE)

DBI::dbDisconnect(winvector_temp_db_handle$db)
winvector_temp_db_handle <- NULL

}
