% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_columns.R
\name{drop_columns}
\alias{drop_columns}
\title{Make a drop columns node (not a relational operation).}
\usage{
drop_columns(source, drops, ..., strict = TRUE)
}
\arguments{
\item{source}{source to drop columns from.}

\item{drops}{list of distinct column names.}

\item{...}{force later arguments to bind by name}

\item{strict}{logical, if TRUE do check columns to be dropped are actually present.}
}
\value{
drop columns node.
}
\description{
Make a drop columns node (not a relational operation).
}
\examples{

if (requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  d <- dbi_copy_to(my_db, 'd',
                   data.frame(AUC = 0.6, R2 = 0.2))
  optree <- drop_columns(d, 'AUC')
  cat(format(optree))
  sql <- to_sql(optree, my_db)
  cat(sql)
  print(DBI::dbGetQuery(my_db, sql))
  DBI::dbDisconnect(my_db)
}

}
