% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_ops.R
\name{rq_coltypes}
\alias{rq_coltypes}
\title{Get column types by example values as a data.frame.}
\usage{
rq_coltypes(db, table_name, ..., prefer_not_NA = FALSE,
  force_check = FALSE)
}
\arguments{
\item{db}{Connection handle.}

\item{table_name}{character table name referring to a non-empty table.}

\item{...}{force later arguments to bind by name.}

\item{prefer_not_NA}{logical, if TRUE try to find an non-NA example for all columns (FALSE just for logical columns).}

\item{force_check}{logical, if TRUE perform checks regardless of check_logical_column_types option setting.}
}
\value{
single row data.frame with example values, not all values necessarily from same database row.
}
\description{
Example values not necessarily all from same row.  Taking values from different rows is
to try to work around NA not carrying type/class info in many cases.
}
\examples{

if(requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")

  # getDBOption(db, "check_logical_column_types", FALSE)
  # options(rq_connection_tests(db))
  # getDBOption(db, "check_logical_column_types", FALSE)

  d <- data.frame(w= c(NA, 1L),
                  x= c(NA, 2.0),
                  y= factor(c(NA, "x")),
                  z= c(NA, "y"),
                  want = c(1, 0),
                  stringsAsFactors=FALSE)
  d <- rq_copy_to(db, "d", d,
                   overwrite = TRUE,
                   temporary = TRUE)
  res <- d \%.>\%
    extend(.,
               wc \%:=\% ifelse(w>1, "x", "y"),
               wn \%:=\% ifelse(w>1, 1, 2),
               xc \%:=\% ifelse(x>1, "x", "y"),
               xn \%:=\% ifelse(x>1, 1, 2),
               yc \%:=\% ifelse(y=="a", "x", "y"),
               yn \%:=\% ifelse(y=="a", "x", "y")) \%.>\%
    materialize(db, .)
  resn <- DBI::dbQuoteIdentifier(db, res$table_name)
  print("full table types")
  print(str(DBI::dbGetQuery(db, paste("SELECT * FROM", resn))))
  print("single row mis-reported types")
  print(str(DBI::dbGetQuery(db, paste("SELECT * FROM", resn, "WHERE want=1"))))
  print("rq_coltypes correct synthetic example row types")
  print(str(rq_coltypes(db, res$table_name, force_check = TRUE)))
  DBI::dbDisconnect(db)
}

}
