% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project.R
\name{project}
\alias{project}
\alias{project_nse}
\alias{aggregate_nse}
\title{project data by grouping, and adding aggregate columns.}
\usage{
project(source, ..., groupby = c(), env = parent.frame())

project_nse(source, ..., groupby = c(), env = parent.frame())

aggregate_nse(source, ..., groupby = c(), env = parent.frame())
}
\arguments{
\item{source}{source to select from.}

\item{...}{new column assignment expressions.}

\item{groupby}{grouping columns.}

\item{env}{environment to look for values in.}
}
\value{
project node.
}
\description{
Supports \code{bquote()} \code{.()}-style name abstraction including \code{.(-)} notation to promote strings to names
(please see here: \url{https://github.com/WinVector/rquery/blob/master/Examples/Substitution/Substitution.md}).
}
\examples{

if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(),
                          ":memory:")
  d <- rq_copy_to(
    my_db, 'd',
    data.frame(group = c('a', 'a', 'b', 'b'),
               val = 1:4,
               stringsAsFactors = FALSE))

  op_tree <- d \%.>\%
    project(., groupby = "group", vmax \%:=\% max(val))
  cat(format(op_tree))
  sql <- to_sql(op_tree, my_db)
  cat(sql)
  execute(my_db, op_tree) \%.>\%
     print(.)

  op_tree <- d \%.>\%
    project(., groupby = NULL, vmax \%:=\% max(val))
  cat(format(op_tree))
  sql <- to_sql(op_tree, my_db)
  cat(sql)
  execute(my_db, op_tree) \%.>\%
    print(.)

  DBI::dbDisconnect(my_db)
}

}
