% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order_expr.R
\name{order_expr_se}
\alias{order_expr_se}
\title{Make a order_expr node.}
\usage{
order_expr_se(source, expr, env = parent.frame())
}
\arguments{
\item{source}{source to select from.}

\item{expr}{expression to order_expr in ascending order.}

\item{env}{environment to look for values in.}
}
\value{
select columns node.
}
\description{
Make a order_expr node.
}
\examples{

if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  d <- rq_copy_to(my_db, 'd',
                   data.frame(AUC = 0.6, R2 = 0.2))
  optree <- order_expr_se(d, "AUC/R2")
  cat(format(optree))
  sql <- to_sql(optree, my_db)
  cat(sql)
  print(DBI::dbGetQuery(my_db, sql))
  DBI::dbDisconnect(my_db)
}
}
