/*
 * Decompiled with CFR 0.152.
 */
package com.github.egonw.rrdf;

import com.github.egonw.rrdf.StringMatrix;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;

public class RJenaHelper {
    public static Model newOntoRdf() throws Exception {
        return ModelFactory.createOntologyModel();
    }

    public static Model newRdf() throws Exception {
        return ModelFactory.createDefaultModel();
    }

    public static Model loadRdf(String string, String string2) throws Exception {
        return RJenaHelper.loadRdf(string, string2, (Model)ModelFactory.createOntologyModel());
    }

    public static Model loadRdf(String string, String string2, Model model) throws Exception {
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        model.read((InputStream)fileInputStream, "", string2);
        return model;
    }

    public static Model fromString(String string, String string2) throws Exception {
        return RJenaHelper.fromString(string, string2, (Model)ModelFactory.createOntologyModel());
    }

    public static Model fromString(String string, String string2, Model model) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        model.read((InputStream)byteArrayInputStream, "", string2);
        return model;
    }

    public static void saveRdf(Model model, String string, String string2) throws Exception {
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        model.write((OutputStream)fileOutputStream, string2);
        ((OutputStream)fileOutputStream).close();
    }

    public static String dump(Model model) {
        StringBuffer stringBuffer = new StringBuffer();
        StmtIterator stmtIterator = model.listStatements();
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            RDFNode rDFNode = statement.getObject();
            stringBuffer.append(statement.getSubject().getLocalName()).append(' ').append(statement.getPredicate().getLocalName()).append(' ').append(rDFNode instanceof Resource ? rDFNode.toString() : '\"' + rDFNode.toString() + "\"").append('\n');
        }
        return stringBuffer.toString();
    }

    public static int tripleCount(Model model) {
        return (int)model.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringMatrix sparql(Model model, String string) throws Exception {
        StringMatrix stringMatrix = null;
        Query query = QueryFactory.create((String)string);
        PrefixMapping prefixMapping = query.getPrefixMapping();
        try (QueryExecution queryExecution = QueryExecutionFactory.create((Query)query, (Model)model);){
            ResultSet resultSet = queryExecution.execSelect();
            stringMatrix = RJenaHelper.convertIntoTable(prefixMapping, resultSet);
        }
        return stringMatrix;
    }

    public static StringMatrix sparqlRemote(String string, String string2) throws Exception {
        return RJenaHelper.sparqlRemote(string, string2, null, null);
    }

    public static StringMatrix sparqlRemoteNoJena(String string, String string2) throws Exception {
        return RJenaHelper.sparqlRemoteNoJena(string, string2, null, null);
    }

    public static StringMatrix sparqlRemoteNoJena(String string, String string2, String string3, String string4) throws Exception {
        BasicCredentialsProvider basicCredentialsProvider;
        Serializable serializable;
        StringMatrix stringMatrix = null;
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        if (string3 != null) {
            serializable = new URL(string);
            basicCredentialsProvider = new BasicCredentialsProvider();
            basicCredentialsProvider.setCredentials(new AuthScope(((URL)serializable).getHost(), -1), (Credentials)new UsernamePasswordCredentials(string3, string4));
            defaultHttpClient.setCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        }
        serializable = new ArrayList();
        serializable.add(new BasicNameValuePair("query", string2));
        basicCredentialsProvider = new UrlEncodedFormEntity((List)((Object)serializable), "UTF-8");
        HttpPost httpPost = new HttpPost(string);
        httpPost.setEntity((HttpEntity)basicCredentialsProvider);
        HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
        HttpEntity httpEntity = httpResponse.getEntity();
        InputStream inputStream = httpEntity.getContent();
        ResultSet resultSet = ResultSetFactory.fromXML((InputStream)inputStream);
        Query query = QueryFactory.create((String)string2);
        PrefixMapping prefixMapping = query.getPrefixMapping();
        stringMatrix = RJenaHelper.convertIntoTable(prefixMapping, resultSet);
        inputStream.close();
        return stringMatrix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringMatrix sparqlRemote(String string, String string2, String string3, String string4) throws Exception {
        StringMatrix stringMatrix = null;
        Query query = QueryFactory.create((String)string2);
        QueryEngineHTTP queryEngineHTTP = (QueryEngineHTTP)QueryExecutionFactory.sparqlService((String)string, (Query)query);
        if (string3 != null) {
            queryEngineHTTP.setBasicAuthentication("" + string3, ("" + string4).toCharArray());
        }
        PrefixMapping prefixMapping = query.getPrefixMapping();
        try {
            ResultSet resultSet = queryEngineHTTP.execSelect();
            stringMatrix = RJenaHelper.convertIntoTable(prefixMapping, resultSet);
        }
        finally {
            queryEngineHTTP.close();
        }
        return stringMatrix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Model construct(Model model, String string) throws Exception {
        Model model2 = null;
        Query query = QueryFactory.create((String)string);
        try (QueryExecution queryExecution = QueryExecutionFactory.create((Query)query, (Model)model);){
            model2 = queryExecution.execConstruct();
        }
        return model2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Model constructRemote(String string, String string2) throws Exception {
        Model model = null;
        Query query = QueryFactory.create((String)string2);
        try (QueryEngineHTTP queryEngineHTTP = (QueryEngineHTTP)QueryExecutionFactory.sparqlService((String)string, (Query)query);){
            model = queryEngineHTTP.execConstruct();
        }
        return model;
    }

    private static StringMatrix convertIntoTable(PrefixMapping prefixMapping, ResultSet resultSet) {
        StringMatrix stringMatrix = new StringMatrix();
        int n = 0;
        while (resultSet.hasNext()) {
            ++n;
            QuerySolution querySolution = resultSet.nextSolution();
            Iterator iterator = querySolution.varNames();
            while (iterator.hasNext()) {
                Object object;
                RDFNode rDFNode;
                String string = (String)iterator.next();
                int n2 = -1;
                if (stringMatrix.hasColumn(string)) {
                    n2 = stringMatrix.getColumnNumber(string);
                } else {
                    n2 = stringMatrix.getColumnCount() + 1;
                    stringMatrix.setColumnName(n2, string);
                }
                if ((rDFNode = querySolution.get(string)) == null) continue;
                if (rDFNode.isResource()) {
                    object = (Resource)rDFNode;
                    String[] stringArray = RJenaHelper.split(prefixMapping, (Resource)object);
                    if (stringArray[0] == null) {
                        if (object.getURI() != null) {
                            stringMatrix.set(n, n2, object.getURI());
                            continue;
                        }
                        stringMatrix.set(n, n2, "" + object.hashCode());
                        continue;
                    }
                    stringMatrix.set(n, n2, stringArray[0] + ":" + stringArray[1]);
                    continue;
                }
                if (rDFNode.isLiteral()) {
                    object = (Literal)rDFNode;
                    stringMatrix.set(n, n2, object.getString());
                    continue;
                }
                object = rDFNode.toString();
                if (((String)object).endsWith("@en")) {
                    object = ((String)object).substring(0, ((String)object).lastIndexOf(64));
                }
                stringMatrix.set(n, n2, (String)object);
            }
        }
        return stringMatrix;
    }

    public static String[] split(PrefixMapping prefixMapping, Resource resource) {
        String string = resource.getURI();
        if (string == null) {
            return new String[]{null, null};
        }
        Map map = prefixMapping.getNsPrefixMap();
        Set set = map.keySet();
        String[] stringArray = new String[]{null, null};
        for (String string2 : set) {
            String string3 = (String)map.get(string2);
            if (!string.startsWith(string3)) continue;
            stringArray[0] = string2;
            stringArray[1] = string.substring(string3.length());
            return stringArray;
        }
        stringArray[1] = string;
        return stringArray;
    }

    public static void addObjectProperty(Model model, String string, String string2, String string3) throws Exception {
        Resource resource = model.createResource(string);
        Property property = model.createProperty(string2);
        Resource resource2 = model.createResource(string3);
        model.add(resource, property, (RDFNode)resource2);
    }

    public static void addDataProperty(Model model, String string, String string2, String string3) throws Exception {
        RJenaHelper.addDataProperty(model, string, string2, string3, null);
    }

    public static void addDataProperty(Model model, String string, String string2, String string3, String string4) throws Exception {
        Resource resource = model.createResource(string);
        Property property = model.createProperty(string2);
        if (string4 == null) {
            model.add(resource, property, string3);
        } else {
            model.add(resource, property, string3, (RDFDatatype)new XSDDatatype(string4));
        }
    }

    public static void addPrefix(Model model, String string, String string2) {
        model.setNsPrefix(string, string2);
    }
}

