/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingUtils;
import com.hp.hpl.jena.sparql.util.NodeUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.Transform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetCompare {
    private static String[] rs1$ = new String[]{"(resultset (?x ?y)", "   (row (?x _:b0) (?y _:b1))", "   (row (?x _:b2) (?y _:b3))", "   (row (?x _:b1) (?y _:b0))", ")"};
    private static String[] rs2$ = new String[]{"(resultset (?x ?y)", "   (row (?x _:c1) (?y _:c0))", "   (row (?x _:c3) (?y _:c2))", "   (row (?x _:c2) (?y _:c3))", ")"};
    private static Transform<QuerySolution, Binding> qs2b = new Transform<QuerySolution, Binding>(){

        @Override
        public Binding convert(QuerySolution item) {
            return BindingUtils.asBinding(item);
        }
    };

    public static boolean equalsByValue(ResultSet rs1, ResultSet rs2) {
        ResultSetRewindable rs1a = ResultSetFactory.makeRewindable(rs1);
        ResultSetRewindable rs2a = ResultSetFactory.makeRewindable(rs2);
        if (ResultSetCompare.equivalent(ResultSetCompare.convert(rs1a), ResultSetCompare.convert(rs2a), new BNodeIso(NodeUtils.sameValue))) {
            return true;
        }
        rs1a.reset();
        rs2a.reset();
        return ResultSetCompare.isomorphic(rs1, rs2);
    }

    public static boolean equalsByTerm(ResultSet rs1, ResultSet rs2) {
        ResultSetRewindable rs1a = ResultSetFactory.makeRewindable(rs1);
        ResultSetRewindable rs2a = ResultSetFactory.makeRewindable(rs2);
        if (ResultSetCompare.equivalent(ResultSetCompare.convert(rs1a), ResultSetCompare.convert(rs2a), new BNodeIso(NodeUtils.sameTerm))) {
            return true;
        }
        rs1a.reset();
        rs2a.reset();
        return ResultSetCompare.isomorphic(rs1, rs2);
    }

    public static boolean equalsByValueAndOrder(ResultSet rs1, ResultSet rs2) {
        return ResultSetCompare.equivalentByOrder(ResultSetCompare.convert(rs1), ResultSetCompare.convert(rs2), new BNodeIso(NodeUtils.sameValue));
    }

    public static boolean equalsByTermAndOrder(ResultSet rs1, ResultSet rs2) {
        return ResultSetCompare.equivalentByOrder(ResultSetCompare.convert(rs1), ResultSetCompare.convert(rs2), new BNodeIso(NodeUtils.sameTerm));
    }

    public static boolean isomorphic(ResultSet rs1, ResultSet rs2) {
        Model m1 = ResultSetFormatter.toModel(rs1);
        Model m2 = ResultSetFormatter.toModel(rs2);
        return m1.isIsomorphicWith(m2);
    }

    public static boolean equal(Binding bind1, Binding bind2, NodeUtils.EqualityTest test) {
        if (bind1 == bind2) {
            return true;
        }
        if (bind1.size() != bind2.size()) {
            return false;
        }
        return ResultSetCompare.containedIn(bind1, bind2, test);
    }

    private static List<Binding> convert(ResultSet rs) {
        return Iter.iter(rs).map(qs2b).toList();
    }

    private static boolean equivalent(Collection<Binding> rows1, Collection<Binding> rows2, NodeUtils.EqualityTest match) {
        if (rows1.size() != rows2.size()) {
            return false;
        }
        for (Binding row1 : rows1) {
            Binding matched = null;
            for (Binding row2 : rows2) {
                if (!ResultSetCompare.equal(row1, row2, match)) continue;
                matched = row2;
                break;
            }
            if (matched == null) {
                return false;
            }
            rows2.remove(matched);
        }
        return true;
    }

    private static boolean equivalentByOrder(List<Binding> rows1, List<Binding> rows2, NodeUtils.EqualityTest match) {
        if (rows1.size() != rows2.size()) {
            return false;
        }
        Iterator<Binding> iter1 = rows1.iterator();
        Iterator<Binding> iter2 = rows2.iterator();
        while (iter1.hasNext()) {
            Binding row2;
            Binding row1 = iter1.next();
            if (ResultSetCompare.equal(row1, row2 = iter2.next(), match)) continue;
            return false;
        }
        return true;
    }

    private static boolean containedIn(Binding bind1, Binding bind2, NodeUtils.EqualityTest test) {
        Iterator<Var> iter1 = bind1.vars();
        for (Var v : Iter.iter(iter1)) {
            Node n1 = bind1.get(v);
            Node n2 = bind2.get(v);
            if (n2 == null) {
                return false;
            }
            if (test.equal(n1, n2)) continue;
            return false;
        }
        return true;
    }

    public static class BNodeIso
    implements NodeUtils.EqualityTest {
        private HashMap<Node, Node> mapping = new HashMap();
        private NodeUtils.EqualityTest literalTest;

        public BNodeIso(NodeUtils.EqualityTest literalTest) {
            this.literalTest = literalTest;
        }

        public boolean equal(Node n1, Node n2) {
            if (n1 == null && n2 == null) {
                return true;
            }
            if (n1 == null) {
                return false;
            }
            if (n2 == null) {
                return false;
            }
            if (n1.isURI() && n2.isURI()) {
                return n1.equals((Object)n2);
            }
            if (n1.isLiteral() && n2.isLiteral()) {
                return this.literalTest.equal(n1, n2);
            }
            if (n1.isBlank() && n2.isBlank()) {
                Node x = this.mapping.get(n1);
                if (x == null) {
                    this.mapping.put(n1, n2);
                    return true;
                }
                return x.equals((Object)n2);
            }
            return false;
        }
    }
}

