/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.sparql.core.ResultBinding;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingComparator;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedResultSet
implements ResultSet {
    QueryIterator qIter;
    int rowNumber = 0;
    List<String> resultVars = null;
    Model model;

    public SortedResultSet(ResultSet rs, List<SortCondition> conditions) {
        this(rs, new BindingComparator(conditions));
    }

    private SortedResultSet(ResultSet rs, Comparator<Binding> comparator) {
        this.model = rs.getResourceModel();
        TreeSet<Binding> sorted = new TreeSet<Binding>(comparator);
        while (rs.hasNext()) {
            Binding b = rs.nextBinding();
            sorted.add(b);
        }
        this.qIter = new QueryIterPlainWrapper(sorted.iterator());
        this.resultVars = rs.getResultVars();
    }

    @Override
    public boolean hasNext() {
        return this.qIter.hasNext();
    }

    @Override
    public QuerySolution next() {
        return new ResultBinding(this.model, this.nextBinding());
    }

    @Override
    public Binding nextBinding() {
        ++this.rowNumber;
        return this.qIter.nextBinding();
    }

    @Override
    public QuerySolution nextSolution() {
        return new ResultBinding(null, this.nextBinding());
    }

    @Override
    public int getRowNumber() {
        return this.rowNumber;
    }

    @Override
    public List<String> getResultVars() {
        return this.resultVars;
    }

    public boolean isOrdered() {
        return true;
    }

    @Override
    public Model getResourceModel() {
        return this.model;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(SortedResultSet.class.getName() + ".remove");
    }

    private Binding copyToBinding(QuerySolution qs) {
        BindingMap b = new BindingMap();
        Iterator<String> iter = qs.varNames();
        while (iter.hasNext()) {
            String varName = iter.next();
            RDFNode rn = qs.get(varName);
            b.add(Var.alloc(varName), rn.asNode());
        }
        return b;
    }
}

