/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.out;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.OutputStream;
import java.util.Iterator;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.out.SinkTripleOutput;
import org.openjena.riot.system.Prologue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NTriplesWriter {
    public static void write(OutputStream out, Graph graph) {
        Prologue prologue = Prologue.create(null, null);
        SinkTripleOutput sink = new SinkTripleOutput(out, prologue);
        NTriplesWriter.graphToSink(graph, (Sink<Triple>)sink);
    }

    private static void graphToSink(Graph graph, Sink<Triple> sink) {
        ExtendedIterator iter = graph.find(Node.ANY, Node.ANY, Node.ANY);
        NTriplesWriter.graphToSink((Iterator<Triple>)iter, sink);
    }

    private static void graphToSink(Iterator<Triple> iter, Sink<Triple> sink) {
        while (iter.hasNext()) {
            Triple triple = iter.next();
            sink.send(triple);
        }
        sink.close();
    }
}

