/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify.request;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.util.FmtUtils;

public class Target {
    public static final Target DEFAULT = new Target(Decl.DEFAULT$);
    public static final Target NAMED = new Target(Decl.NAMED$);
    public static final Target ALL = new Target(Decl.ALL$);
    private final Decl decl;
    private final Node graphIRI;

    public static Target create(String iri2) {
        return new Target(Node.createURI((String)iri2));
    }

    public static Target create(Node graphName) {
        return new Target(graphName);
    }

    private Target(Decl decl) {
        this.graphIRI = null;
        this.decl = decl;
    }

    private Target(Node iri2) {
        this.graphIRI = iri2;
        this.decl = Decl.IRI$;
    }

    public boolean isDefault() {
        return this.decl == Decl.DEFAULT$;
    }

    public boolean isAll() {
        return this.decl == Decl.ALL$;
    }

    public boolean isAllNamed() {
        return this.decl == Decl.NAMED$;
    }

    public boolean isOneNamedGraph() {
        return this.decl == Decl.IRI$;
    }

    public Node getGraph() {
        return this.graphIRI;
    }

    public String toString() {
        if (this.isOneNamedGraph()) {
            return this.decl.toString() + " " + FmtUtils.stringForNode(this.graphIRI);
        }
        return this.decl.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Decl {
        DEFAULT$,
        NAMED$,
        ALL$,
        IRI$;

    }
}

