/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.io;

import com.hp.hpl.jena.util.FileUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import org.openjena.atlas.AtlasException;
import org.openjena.atlas.logging.Log;

public class IO {
    public static final int EOF = -1;
    public static final int UNSET = -2;
    public static final String encodingUTF8 = "utf-8";
    public static final String encodingAscii = "ascii";
    private static Charset utf8 = null;
    private static Charset ascii = null;
    private static final int BUFFER_SIZE = 8192;

    public static InputStream openFile(String filename) {
        try {
            if (filename == null || filename.equals("-")) {
                return System.in;
            }
            if (filename.startsWith("file:")) {
                filename = filename.substring("file:".length());
            }
            InputStream in = new FileInputStream(filename);
            if (filename.endsWith(".gz")) {
                in = new GZIPInputStream(in);
            }
            return in;
        }
        catch (Exception ex) {
            throw new AtlasException(ex);
        }
    }

    public static Reader openFileUTF8(String filename) {
        return IO.openFileReader(filename, utf8);
    }

    public static Reader openFileASCII(String filename) {
        return IO.openFileReader(filename, ascii);
    }

    private static Reader openFileReader(String filename, Charset charset) {
        InputStream in = IO.openFile(filename);
        return new InputStreamReader(in, charset);
    }

    public static Reader asUTF8(InputStream in) {
        return new InputStreamReader(in, utf8.newDecoder());
    }

    public static Reader asASCII(InputStream in) {
        return new InputStreamReader(in, ascii.newDecoder());
    }

    public static void close(InputStream in) {
        try {
            in.close();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public static void close(OutputStream out) {
        try {
            out.close();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public static void close(Reader in) {
        try {
            in.close();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public static void close(Writer out) {
        try {
            out.close();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public static void exception(IOException ex) {
        throw new AtlasException(ex);
    }

    public static void flush(OutputStream out) {
        try {
            out.flush();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public static void flush(Writer out) {
        try {
            out.flush();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public static byte[] readWholeFile(InputStream in) {
        try {
            int l;
            ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
            byte[] buff = new byte[8192];
            while ((l = in.read(buff)) > 0) {
                out.write(buff, 0, l);
            }
            out.close();
            return out.toByteArray();
        }
        catch (IOException ex) {
            IO.exception(ex);
            return null;
        }
    }

    public static String readWholeFileAsUTF8(String filename) throws IOException {
        FileInputStream in = new FileInputStream(filename);
        return IO.readWholeFileAsUTF8(in);
    }

    public static String readWholeFileAsUTF8(InputStream in) throws IOException {
        BufferedReader r = new BufferedReader(IO.asUTF8(in), 1024);
        return IO.readWholeFileAsUTF8(r);
    }

    private static String readWholeFileAsUTF8(Reader r) throws IOException {
        int l;
        StringWriter sw = new StringWriter(8192);
        char[] buff = new char[8192];
        while ((l = r.read(buff)) >= 0) {
            sw.write(buff, 0, l);
        }
        sw.close();
        return sw.toString();
    }

    static {
        try {
            utf8 = Charset.forName(encodingUTF8);
            ascii = Charset.forName(encodingAscii);
        }
        catch (Throwable ex) {
            Log.fatal(FileUtils.class, "Failed to get charset", ex);
        }
    }
}

