/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util.graph;

import com.hp.hpl.jena.sparql.util.StringUtils;
import com.hp.hpl.jena.sparql.util.Timer;
import com.hp.hpl.jena.sparql.util.graph.GraphListenerCounter;
import java.util.Date;

public class GraphLoadMonitor
extends GraphListenerCounter {
    Timer timer = null;
    private long lastTime = 0L;
    private boolean displayMemory = false;
    String label = null;
    String summaryLabel = null;

    public GraphLoadMonitor(int addNotePoint, boolean displayMemory) {
        super(addNotePoint);
        this.displayMemory = displayMemory;
        this.resetTimer();
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setSummaryLabel(String label) {
        this.summaryLabel = label;
    }

    public void startMonitor() {
        this.resetTimer();
    }

    public void finishMonitor() {
        if (this.timer != null) {
            this.timer.endTimer();
        }
    }

    public void resetTimer() {
        if (this.timer != null) {
            this.timer.endTimer();
        }
        this.timer = new Timer();
        this.timer.startTimer();
    }

    public long triplesLoaded() {
        return this.getAddCount();
    }

    protected void addTick() {
        long soFar = this.timer.readTimer();
        long thisTime = soFar - this.lastTime;
        long count = this.getAddCount();
        long ticks = this.getAddTicks();
        long tpsBatch = (long)this.getAddTickSize() * 1000L / thisTime;
        long tpsAvg = count * 1000L / soFar;
        String msg = "Add: " + GraphLoadMonitor.num(count) + " triples  (Batch: " + GraphLoadMonitor.num(tpsBatch) + " / Run: " + GraphLoadMonitor.num(tpsAvg) + ")";
        if (this.label != null) {
            msg = msg + this.label;
        }
        if (this.displayMemory) {
            long mem = Runtime.getRuntime().totalMemory();
            long free = Runtime.getRuntime().freeMemory();
            msg = msg + "   [M:" + GraphLoadMonitor.num(mem) + "/F:" + GraphLoadMonitor.num(free) + "]";
        }
        GraphLoadMonitor.println(this.label, msg);
        if (ticks > 0L && ticks % 10L == 0L) {
            String x = GraphLoadMonitor.num((float)soFar / 1000.0f);
            String timestamp = StringUtils.str(new Date());
            GraphLoadMonitor.println(this.label, "  Elapsed: " + x + " seconds [" + timestamp + "]");
        }
        this.lastTime = soFar;
    }

    private static String num(long v) {
        return StringUtils.str(v);
    }

    private static String num(float value) {
        return StringUtils.str(value);
    }

    protected void deleteTick() {
    }

    protected void startRead() {
        this.startMonitor();
    }

    protected void finishRead() {
        this.finishMonitor();
        this.printAtEnd();
    }

    private void printAtEnd() {
        long timeMilli = this.timer.getTimeInterval();
        GraphLoadMonitor.println(this.summaryLabel, GraphLoadMonitor.num(this.getAddCount()) + " triples: loaded in " + GraphLoadMonitor.num((float)timeMilli / 1000.0f) + " seconds [" + GraphLoadMonitor.num(1000.0f * (float)this.getAddCount() / (float)timeMilli) + " triples/s]");
    }

    private static void println(String label, String line) {
        if (label != null) {
            System.out.print(label);
        }
        System.out.println(line);
    }
}

