/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.exceptions;

import com.hp.hpl.jena.assembler.exceptions.AssemblerException;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmbiguousSpecificTypeException
extends AssemblerException {
    protected final List<Resource> types;

    public AmbiguousSpecificTypeException(Resource root, ArrayList<Resource> types) {
        super(root, AmbiguousSpecificTypeException.makeMessage(root, types));
        this.types = types;
    }

    private static String makeMessage(Resource root, List<Resource> types) {
        return "cannot find a most specific type for " + AmbiguousSpecificTypeException.nice(root) + ", which has as possibilities:" + AmbiguousSpecificTypeException.nice(types) + ".";
    }

    private static String nice(List<Resource> types) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < types.size(); ++i) {
            result.append(" ").append(AmbiguousSpecificTypeException.nice(types.get(i)));
        }
        return result.toString();
    }

    public List<Resource> getTypes() {
        return this.types;
    }
}

